/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.script;

import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.JpaScanner;
import com.axelor.rpc.Context;
import com.axelor.script.AbstractScriptHelper;
import com.axelor.script.ScriptBindings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.script.Bindings;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyScriptHelper
extends AbstractScriptHelper {
    private static final CompilerConfiguration config = new CompilerConfiguration();
    private static final int DEFAULT_CACHE_SIZE = 500;
    private static final int DEFAULT_CACHE_EXPIRE_TIME = 60;
    private static int cacheSize;
    private static int cacheExpireTime;
    private static final GroovyClassLoader GCL;
    private static final LoadingCache<String, Class<?>> SCRIPT_CACHE;

    public GroovyScriptHelper(Bindings bindings) {
        this.setBindings(bindings);
    }

    public GroovyScriptHelper(Context context) {
        this(new ScriptBindings(context));
    }

    @Override
    public Object eval(final String expr, Bindings bindings) throws Exception {
        Class klass = (Class)SCRIPT_CACHE.get((Object)expr);
        Script script = (Script)klass.newInstance();
        script.setBinding(new Binding(bindings){

            public Object getVariable(String name) {
                try {
                    return super.getVariable(name);
                }
                catch (MissingPropertyException e) {
                    if (name.startsWith("_") || name.startsWith("$")) {
                        return null;
                    }
                    GroovyScriptHelper.this.log.warn("No such field in: {} -- ({})", (Object)expr, (Object)name);
                    return null;
                }
            }
        });
        return script.run();
    }

    static {
        config.getOptimizationOptions().put("indy", Boolean.TRUE);
        config.getOptimizationOptions().put("int", Boolean.FALSE);
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStaticImport("__repo__", JpaRepository.class.getName(), "of");
        importCustomizer.addStaticImport(Helpers.class.getName(), "doInJPA");
        importCustomizer.addImports(new String[]{"java.time.ZonedDateTime"});
        importCustomizer.addImports(new String[]{"java.time.LocalDateTime"});
        importCustomizer.addImports(new String[]{"java.time.LocalDate"});
        importCustomizer.addImports(new String[]{"java.time.LocalTime"});
        config.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        try {
            cacheSize = Integer.parseInt(System.getProperty("axelor.ScriptCacheSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cacheExpireTime = Integer.parseInt(System.getProperty("axelor.ScriptCacheExpireTime"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cacheSize <= 0) {
            cacheSize = 500;
        }
        if (cacheExpireTime <= 0) {
            cacheExpireTime = 60;
        }
        GCL = new GroovyClassLoader(JpaScanner.getClassLoader(), config);
        SCRIPT_CACHE = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterAccess((long)cacheExpireTime, TimeUnit.MINUTES).build(new CacheLoader<String, Class<?>>(){

            public Class<?> load(String code) throws Exception {
                try {
                    Class clazz = GCL.parseClass(code);
                    return clazz;
                }
                finally {
                    GCL.clearCache();
                }
            }
        });
    }

    public static class Helpers {
        public static <T> T doInJPA(Function<EntityManager, T> task) {
            Object[] result = new Object[]{null};
            JPA.runInTransaction(() -> {
                result[0] = task.apply(JPA.em());
            });
            return (T)result[0];
        }
    }
}

