/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.team.db.repo;

import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.mail.db.MailFollower;
import com.axelor.mail.db.repo.MailFollowerRepository;
import com.axelor.team.db.Team;
import java.util.Map;
import javax.persistence.TypedQuery;

public class TeamRepository
extends JpaRepository<Team> {
    public TeamRepository() {
        super(Team.class);
    }

    public Team findByName(String name) {
        return (Team)this.all().filter("self.name = :name").bind("name", name).fetchOne();
    }

    @Override
    public Team save(Team entity) {
        Team team = super.save(entity);
        MailFollowerRepository followers = Beans.get(MailFollowerRepository.class);
        if (team.getMembers() != null) {
            team.getMembers().forEach(user -> followers.follow((Model)team, (User)user));
        } else {
            followers.findAll(entity).forEach(followers::unfollow);
        }
        TypedQuery query = JPA.em().createQuery("SELECT f FROM MailFollower f LEFT JOIN f.user u WHERE f.relatedModel = :model \tAND f.relatedId = :id \tAND u.id NOT IN \t\t(SELECT x.id FROM Team t LEFT JOIN t.members x WHERE t.id = :id)", MailFollower.class);
        query.setParameter("model", (Object)Team.class.getName());
        query.setParameter("id", (Object)team.getId());
        query.getResultList().forEach(f -> followers.unfollow(team, f.getUser()));
        return team;
    }

    @Override
    public void remove(Team entity) {
        MailFollowerRepository followers = Beans.get(MailFollowerRepository.class);
        followers.findAll(entity).forEach(followers::unfollow);
        super.remove(entity);
    }

    @Override
    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        if (json == null || json.get("id") == null) {
            return json;
        }
        Team entity = (Team)this.find((Long)json.get("id"));
        if (entity == null) {
            return json;
        }
        MailFollowerRepository followers = Beans.get(MailFollowerRepository.class);
        MailFollower follower = followers.findOne((Model)entity, AuthUtils.getUser());
        json.put("_following", follower != null && follower.getArchived() == Boolean.FALSE);
        json.put("_image", entity.getImage() != null);
        return json;
    }
}

