/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.text;

import com.axelor.app.AppSettings;
import com.axelor.common.FileUtils;
import com.axelor.common.ResourceUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.MetaStore;
import com.axelor.script.ScriptBindings;
import com.axelor.text.Renderer;
import com.axelor.text.Template;
import com.axelor.text.Templates;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.io.CharStreams;
import groovy.text.GStringTemplateEngine;
import groovy.text.StreamingTemplateEngine;
import groovy.text.TemplateEngine;
import groovy.xml.XmlUtil;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyTemplates
implements Templates {
    private static final TemplateEngine GSTRING_ENGINE = new GStringTemplateEngine();
    private static final TemplateEngine STREAMING_ENGINE = new StreamingTemplateEngine();
    private static final String DEFAULT_TEMPLATE_DIR = "{java.io.tmpdir}/axelor/templates";
    private static final String TEMPLATE_DIR = AppSettings.get().getPath("template.search.dir", "{java.io.tmpdir}/axelor/templates");
    private static final Pattern INCLUDE_PAT = Pattern.compile("\\{\\{\\<\\s*(.*?)\\s*\\>\\}\\}");

    @Override
    public Template fromText(String text) {
        return new GroovyTemplate(text);
    }

    @Override
    public Template from(File file) throws IOException {
        return this.from(new FileReader(file));
    }

    @Override
    public Template from(Reader reader) throws IOException {
        return this.fromText(CharStreams.toString((Readable)reader));
    }

    class FormatHelper {
        private final Logger log = LoggerFactory.getLogger(FormatHelper.class);

        FormatHelper() {
        }

        public Object escape(Object value) {
            if (value == null) {
                return "";
            }
            return XmlUtil.escapeXml((String)value.toString());
        }

        public String text(Object bean, String expr) {
            if (bean == null) {
                return "";
            }
            expr = expr.replaceAll("\\?", "");
            return this.getTitle(EntityHelper.getEntityClass(bean), expr, this.getValue(bean, expr));
        }

        private String getTitle(Class<?> klass, String expr, Object value) {
            if (value == null) {
                return "";
            }
            Property property = this.getProperty(klass, expr);
            String val = value == null ? "" : value.toString();
            try {
                return MetaStore.getSelectionItem(property.getSelection(), val).getLocalizedTitle();
            }
            catch (Exception exception) {
                return val;
            }
        }

        private Property getProperty(Class<?> beanClass, String name) {
            Iterator iter = Splitter.on((String)".").split((CharSequence)name).iterator();
            Property p = Mapper.of(beanClass).getProperty((String)iter.next());
            while (iter.hasNext() && p != null) {
                p = Mapper.of(p.getTarget()).getProperty((String)iter.next());
            }
            return p;
        }

        private Object getValue(Object bean, String expr) {
            if (bean == null) {
                return null;
            }
            Iterator iter = Splitter.on((String)".").split((CharSequence)expr).iterator();
            Object obj = null;
            obj = bean instanceof Map ? (Object)((Map)bean).get(iter.next()) : Mapper.of(EntityHelper.getEntityClass(bean)).get(bean, (String)iter.next());
            if (iter.hasNext() && obj != null) {
                return this.getValue(obj, Joiner.on((String)".").join(iter));
            }
            return obj;
        }

        public void info(String text, Object ... params) {
            this.log.info(text, params);
        }

        public void debug(String text, Object ... params) {
            this.log.debug(text, params);
        }

        public void error(String text, Object ... params) {
            this.log.error(text, params);
        }

        public void trace(String text, Object ... params) {
            this.log.trace(text, params);
        }
    }

    class GroovyTemplate
    implements Template {
        private String text;

        public GroovyTemplate(String text) {
            this.text = text;
        }

        private boolean isWordTemplate(String text) {
            if (StringUtils.isBlank((CharSequence)text)) {
                return false;
            }
            return text.indexOf("<?mso-application") > -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String read(String included) throws IOException {
            InputStreamReader reader = null;
            File file = FileUtils.getFile((String)TEMPLATE_DIR, (String[])new String[]{included});
            if (file.isFile()) {
                reader = new FileReader(file);
            } else {
                InputStream stream = ResourceUtils.getResourceStream((String)included);
                if (stream != null) {
                    reader = new InputStreamReader(stream);
                }
            }
            if (reader == null) {
                return "";
            }
            try {
                String string = CharStreams.toString((Readable)reader);
                return string;
            }
            finally {
                ((Reader)reader).close();
            }
        }

        private String process(String text) {
            if (StringUtils.isBlank((CharSequence)text)) {
                return "";
            }
            text = text.replaceAll("\\$\\{\\s*(\\w+)(\\?)?\\.([^}]*?)\\s*\\|\\s*text\\s*\\}", "\\${__fmt__.text($1, '$3')}");
            text = text.replaceAll("\\$\\{\\s*([^}]*?)\\s*\\|\\s*text\\s*\\}", "\\${__fmt__.text(it, '$1')}");
            if ((text = text.replaceAll("\\$\\{\\s*([^}]*?)\\s*\\|\\s*e\\s*\\}", "\\${($1) ?: ''}")).trim().startsWith("<?xml ")) {
                text = text.replaceAll("\\$\\{(.*?)\\}", "\\${__fmt__.escape($1)}");
            }
            StringBuilder builder = new StringBuilder();
            Matcher matcher = INCLUDE_PAT.matcher(text);
            int position = 0;
            while (matcher.find()) {
                builder.append(text.substring(position, matcher.start()));
                position = matcher.end();
                try {
                    String include = this.read(matcher.group(1));
                    builder.append(this.process(include));
                }
                catch (IOException iOException) {}
            }
            builder.append(text.substring(position));
            return builder.toString();
        }

        @Override
        public Renderer make(Map<String, Object> context) {
            final ScriptBindings bindings = new ScriptBindings(context);
            String text = this.process(this.text);
            TemplateEngine engine = this.isWordTemplate(text) ? STREAMING_ENGINE : GSTRING_ENGINE;
            bindings.put("__fmt__", (Object)new FormatHelper());
            try {
                final groovy.text.Template template = engine.createTemplate(text);
                return new Renderer(){

                    @Override
                    public void render(Writer out) throws IOException {
                        template.make((Map)bindings).writeTo(out);
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public <T extends Model> Renderer make(final T context) {
            final Mapper mapper = context == null ? null : Mapper.of(EntityHelper.getEntityClass(context));
            HashMap<String, Object> ctx = new HashMap<String, Object>(){

                @Override
                public boolean containsKey(Object key) {
                    return mapper != null && mapper.getProperty((String)key) != null;
                }

                @Override
                public Object get(Object key) {
                    return mapper == null ? null : mapper.get(context, (String)key);
                }
            };
            return this.make((T)((Object)ctx));
        }
    }
}

