/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillInboundDomain;
import com.microtripit.mandrillapp.lutung.view.MandrillInboundRecipient;
import com.microtripit.mandrillapp.lutung.view.MandrillMailboxRoute;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;

public class MandrillInboundApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillInboundApi(String key) {
        this.key = key;
    }

    MandrillInboundDomain[] domains() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/inbound/domains.json", MandrillUtil.paramsWithKey(this.key), MandrillInboundDomain[].class);
    }

    MandrillMailboxRoute[] routes(String domain) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("domain", domain);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/inbound/routes.json", params, MandrillMailboxRoute[].class);
    }

    MandrillInboundRecipient[] sendRaw(String rawMessage, Collection<String> to) throws MandrillApiError, IOException {
        return this.sendRaw(rawMessage, to, null, null, null);
    }

    MandrillInboundRecipient[] sendRaw(String rawMessage, Collection<String> to, String mailFrom, String helo, String clientAddress) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("raw_message", rawMessage);
        params.put("to", to);
        params.put("mail_from", mailFrom);
        params.put("helo", helo);
        params.put("client_address", clientAddress);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/inbound/send-raw.json", params, MandrillInboundRecipient[].class);
    }
}

