/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillDedicatedIp;
import com.microtripit.mandrillapp.lutung.view.MandrillDedicatedIpPool;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;

public class MandrillIpsApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillIpsApi(String key) {
        this.key = key;
    }

    public MandrillDedicatedIp[] list() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/list.json", MandrillUtil.paramsWithKey(this.key), MandrillDedicatedIp[].class);
    }

    public MandrillDedicatedIp info(String ip) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("ip", ip);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/info.json", params, MandrillDedicatedIp.class);
    }

    public Date provision(Boolean warmup, String pool) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("warmup", warmup);
        params.put("pool", pool);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/provision.json", params, DateWrapper.class).getRequestedAt();
    }

    public MandrillDedicatedIp startWarmup(String ip) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("ip", ip);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/start-warmup.json", params, MandrillDedicatedIp.class);
    }

    public MandrillDedicatedIp cancelWarmup(String ip) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("ip", ip);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/cancel-warmup.json", params, MandrillDedicatedIp.class);
    }

    public MandrillDedicatedIp setPool(String ip, String pool, Boolean createPool) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("ip", ip);
        params.put("pool", pool);
        params.put("create_pool", createPool);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/set-pool.json", params, MandrillDedicatedIp.class);
    }

    public Boolean delete(String ip) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("ip", ip);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/delete.json", params, DeleteResponse.class).getDeleted();
    }

    public MandrillDedicatedIpPool[] listPools() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/list-pools.json", MandrillUtil.paramsWithKey(this.key), MandrillDedicatedIpPool[].class);
    }

    public MandrillDedicatedIpPool poolInfo(String pool) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("pool", pool);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/pool-info.json", params, MandrillDedicatedIpPool.class);
    }

    public MandrillDedicatedIpPool createPool(String pool) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("pool", pool);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/create-pool.json", params, MandrillDedicatedIpPool.class);
    }

    public Boolean deletePool(String pool) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("pool", pool);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/delete-pool.json", params, DeletePoolResponse.class).getDeleted();
    }

    public MandrillDedicatedIp.MandrillDnsCheck checkCustomDns(String ip, String domain) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("ip", ip);
        params.put("domain", domain);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/check-custom-dns.json", params, MandrillDedicatedIp.MandrillDnsCheck.class);
    }

    public MandrillDedicatedIp setCustomDns(String ip, String domain) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("ip", ip);
        params.put("domain", domain);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/ips/set-custom-dns.json", params, MandrillDedicatedIp.class);
    }

    public static class DeletePoolResponse {
        private String pool;
        private Boolean deleted;

        public String getPool() {
            return this.pool;
        }

        public Boolean getDeleted() {
            return this.deleted;
        }
    }

    public static class DeleteResponse {
        private String ip;
        private Boolean deleted;

        public String getIp() {
            return this.ip;
        }

        public Boolean getDeleted() {
            return this.deleted;
        }
    }

    public static class DateWrapper {
        private Date requested_at;

        public Date getRequestedAt() {
            return this.requested_at;
        }
    }
}

