/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.model.MandrillHelperClasses;
import com.microtripit.mandrillapp.lutung.view.MandrillRejectsEntry;
import java.io.IOException;
import java.util.HashMap;

public class MandrillRejectsApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillRejectsApi(String key) {
        this.key = key;
    }

    public Boolean add(String email, String comment, String subaccount) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("email", email);
        params.put("comment", comment);
        params.put("subaccount", subaccount);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/rejects/add.json", params, MandrillHelperClasses.MandrillRejectsAdded.class).getAdded();
    }

    public MandrillRejectsEntry[] list(String email, Boolean includeExpired) throws MandrillApiError, IOException {
        return this.list(email, includeExpired, null);
    }

    public MandrillRejectsEntry[] list(String email, Boolean includeExpired, String subaccount) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("email", email);
        params.put("include_expired", includeExpired);
        if (subaccount != null) {
            params.put("subaccount", subaccount);
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/rejects/list.json", params, MandrillRejectsEntry[].class);
    }

    public Boolean delete(String email) throws MandrillApiError, IOException {
        return this.delete(email, null);
    }

    public Boolean delete(String email, String subaccount) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("email", email);
        if (subaccount != null) {
            params.put("subaccount", subaccount);
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/rejects/delete.json", params, MandrillHelperClasses.MandrillRejectsDeleted.class).getDeleted();
    }
}

