/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillSubaccountInfo;
import java.io.IOException;
import java.util.HashMap;

public class MandrillSubaccountsApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillSubaccountsApi(String key) {
        this.key = key;
    }

    public MandrillSubaccountInfo[] list(String q) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("q", q);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/subaccounts/list.json", params, MandrillSubaccountInfo[].class);
    }

    public MandrillSubaccountInfo add(String id, String name, String notes, Integer customQuota) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        params.put("name", name);
        params.put("notes", notes);
        params.put("custom_quota", customQuota);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/subaccounts/add.json", params, MandrillSubaccountInfo.class);
    }

    public MandrillSubaccountInfo info(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/subaccounts/info.json", params, MandrillSubaccountInfo.class);
    }

    public MandrillSubaccountInfo update(String id, String name, String notes, Integer customQuota) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        params.put("name", name);
        params.put("notes", notes);
        params.put("customQuota", customQuota);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/subaccounts/update.json", params, MandrillSubaccountInfo.class);
    }

    public MandrillSubaccountInfo delete(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/subaccounts/delete.json", params, MandrillSubaccountInfo.class);
    }

    public MandrillSubaccountInfo pause(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/subaccounts/pause.json", params, MandrillSubaccountInfo.class);
    }

    public MandrillSubaccountInfo resume(String id) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("id", id);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/subaccounts/resume.json", params, MandrillSubaccountInfo.class);
    }
}

