/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.view.MandrillTag;
import com.microtripit.mandrillapp.lutung.view.MandrillTimeSeries;
import java.io.IOException;
import java.util.HashMap;

public class MandrillTagsApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillTagsApi(String key) {
        this.key = key;
    }

    public MandrillTag[] list() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/tags/list.json", MandrillUtil.paramsWithKey(this.key), MandrillTag[].class);
    }

    public MandrillTag delete(String tagName) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("tag", tagName);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/tags/delete.json", params, MandrillTag.class);
    }

    public MandrillTag info(String tagName) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("tag", tagName);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/tags/info.json", params, MandrillTag.class);
    }

    public MandrillTimeSeries[] timeSeries(String tagName) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("tag", tagName);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/tags/time-series.json", params, MandrillTimeSeries[].class);
    }

    public MandrillTimeSeries[] allTimeSeries() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/tags/all-time-series.json", MandrillUtil.paramsWithKey(this.key), MandrillTimeSeries[].class);
    }
}

