/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.controller;

import com.microtripit.mandrillapp.lutung.controller.MandrillUtil;
import com.microtripit.mandrillapp.lutung.model.MandrillApiError;
import com.microtripit.mandrillapp.lutung.model.MandrillContentWrapper;
import com.microtripit.mandrillapp.lutung.model.MandrillHelperClasses;
import com.microtripit.mandrillapp.lutung.view.MandrillTemplate;
import com.microtripit.mandrillapp.lutung.view.MandrillTimeSeries;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MandrillTemplatesApi {
    private static final String rootUrl = "https://mandrillapp.com/api/1.0/";
    private final String key;

    public MandrillTemplatesApi(String key) {
        this.key = key;
    }

    public MandrillTemplate add(String name, String code, Boolean publish) throws MandrillApiError, IOException {
        return this.add(name, null, null, null, code, null, publish, null);
    }

    public MandrillTemplate add(String name, String code, Boolean publish, String[] labels) throws MandrillApiError, IOException {
        return this.add(name, null, null, null, code, null, publish, labels);
    }

    public MandrillTemplate add(String name, String fromEmail, String fromName, String subject, String code, String text, Boolean publish, String[] labels) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("name", name);
        params.put("from_email", fromEmail);
        params.put("from_name", fromName);
        params.put("subject", subject);
        params.put("code", code);
        params.put("text", text);
        params.put("publish", publish);
        params.put("labels", labels);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/add.json", params, MandrillTemplate.class);
    }

    public MandrillTemplate info(String name) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("name", name);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/info.json", params, MandrillTemplate.class);
    }

    public MandrillTemplate update(String name, String code, Boolean publish) throws MandrillApiError, IOException {
        return this.update(name, null, null, null, code, null, publish, null);
    }

    public MandrillTemplate update(String name, String code, Boolean publish, String[] labels) throws MandrillApiError, IOException {
        return this.update(name, null, null, null, code, null, publish, labels);
    }

    public MandrillTemplate update(String name, String fromEmail, String fromName, String subject, String code, String text, Boolean publish, String[] labels) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("name", name);
        params.put("from_email", fromEmail);
        params.put("from_name", fromName);
        params.put("subject", subject);
        params.put("code", code);
        params.put("text", text);
        params.put("publish", publish);
        params.put("labels", labels);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/update.json", params, MandrillTemplate.class);
    }

    public MandrillTemplate publish(String name) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("name", name);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/publish.json", params, MandrillTemplate.class);
    }

    public MandrillTemplate delete(String name) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("name", name);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/delete.json", params, MandrillTemplate.class);
    }

    public MandrillTemplate[] list() throws MandrillApiError, IOException {
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/list.json", MandrillUtil.paramsWithKey(this.key), MandrillTemplate[].class);
    }

    public MandrillTemplate[] list(String label) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("label", label);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/list.json", params, MandrillTemplate[].class);
    }

    public MandrillTimeSeries[] timeSeries(String name) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("name", name);
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/time-series.json", params, MandrillTimeSeries[].class);
    }

    public String render(String name, Map<String, String> templateContent, Map<String, String> mergeVars) throws MandrillApiError, IOException {
        HashMap<String, Object> params = MandrillUtil.paramsWithKey(this.key);
        params.put("template_name", name);
        if (templateContent != null && !templateContent.isEmpty()) {
            ArrayList<MandrillContentWrapper> contents = new ArrayList<MandrillContentWrapper>(templateContent.size());
            for (String cName : templateContent.keySet()) {
                contents.add(MandrillContentWrapper.create(cName, templateContent.get(cName)));
            }
            params.put("template_content", contents);
        }
        if (mergeVars != null && !mergeVars.isEmpty()) {
            ArrayList<MandrillContentWrapper> vars = new ArrayList<MandrillContentWrapper>(mergeVars.size());
            for (String cName : mergeVars.keySet()) {
                vars.add(MandrillContentWrapper.create(cName, mergeVars.get(cName)));
            }
            params.put("merge_vars", vars);
        }
        return MandrillUtil.query("https://mandrillapp.com/api/1.0/templates/render.json", params, MandrillHelperClasses.MandrillRenderTemplateResponse.class).getHtml();
    }
}

