/*
 * Decompiled with CFR 0.152.
 */
package com.microtripit.mandrillapp.lutung.model;

import com.microtripit.mandrillapp.lutung.logging.Logger;
import com.microtripit.mandrillapp.lutung.logging.LoggerFactory;
import com.microtripit.mandrillapp.lutung.model.HandleResponseException;
import com.microtripit.mandrillapp.lutung.model.LutungGsonUtils;
import com.microtripit.mandrillapp.lutung.model.RequestModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;

public final class MandrillRequest<OUT>
implements RequestModel<OUT> {
    private static final Logger log = LoggerFactory.getLogger(MandrillRequest.class);
    private final String url;
    private final Class<OUT> responseContentType;
    private final Map<String, ? extends Object> requestParams;

    public MandrillRequest(String url, Map<String, ? extends Object> params, Class<OUT> responseType) {
        if (responseType == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.requestParams = params;
        this.responseContentType = responseType;
    }

    @Override
    public final String getUrl() {
        return this.url;
    }

    @Override
    public final HttpRequestBase getRequest() throws IOException {
        String paramsStr = LutungGsonUtils.getGson().toJson(this.requestParams, this.requestParams.getClass());
        log.debug("raw content for request:\n" + paramsStr);
        StringEntity entity = new StringEntity(paramsStr, "UTF-8");
        entity.setContentType("application/json");
        HttpPost request = new HttpPost(this.url);
        request.setEntity((HttpEntity)entity);
        return request;
    }

    @Override
    public final boolean validateResponseStatus(int httpResponseStatus) {
        return httpResponseStatus == 200;
    }

    @Override
    public final OUT handleResponse(InputStream is) throws HandleResponseException {
        String raw = null;
        try {
            raw = IOUtils.toString((InputStream)is);
            log.debug("raw content from response:\n" + raw);
            return (OUT)LutungGsonUtils.getGson().fromJson(raw, this.responseContentType);
        }
        catch (Throwable t) {
            String msg = "Error handling Mandrill response " + (raw != null ? ": '" + raw + "'" : "");
            throw new HandleResponseException(msg, t);
        }
    }
}

