/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Department;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContractType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_DPAE", indexes={@Index(columnList="employee"), @Index(columnList="company"), @Index(columnList="company_address"), @Index(columnList="health_service_address"), @Index(columnList="department_of_birth"), @Index(columnList="city_of_birth"), @Index(columnList="country_of_birth"), @Index(columnList="contract_type")})
public class DPAE
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_DPAE_SEQ")
    @SequenceGenerator(name="HR_DPAE_SEQ", sequenceName="HR_DPAE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Registration code")
    private String registrationCode;
    @Widget(title="Main activity code")
    @Size(min=5, max=5)
    private String mainActivityCode;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Company address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address companyAddress;
    @Widget(title="Company fixed phone")
    private String companyFixedPhone;
    @Widget(title="Health service")
    private String healthService;
    @Widget(title="Health service address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address healthServiceAddress;
    @Widget(title="Last name")
    private String lastName;
    @Widget(title="First name")
    private String firstName;
    @Widget(title="Social security number")
    @Size(min=12, max=15)
    private String socialSecurityNumber;
    @Widget(title="Sex", selection="employee.hr.sex.select")
    private String sexSelect;
    @Widget(title="Date of birth")
    private LocalDate birthDate;
    @Widget(title="Department of birth")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Department departmentOfBirth;
    @Widget(title="City of birth")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private City cityOfBirth;
    @Widget(title="Country of birth")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country countryOfBirth;
    @Widget(title="Date of hire")
    private LocalDate hireDate;
    @Widget(title="Time of hire")
    private LocalTime hireTime;
    @Widget(title="Trial period duration")
    private String trialPeriodDuration;
    @Widget(title="Contract type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmploymentContractType contractType;
    @Widget(title="End date of hire")
    private LocalDate contractEndDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public String getRegistrationCode() {
        return this.registrationCode;
    }

    public void setRegistrationCode(String registrationCode) {
        this.registrationCode = registrationCode;
    }

    public String getMainActivityCode() {
        return this.mainActivityCode;
    }

    public void setMainActivityCode(String mainActivityCode) {
        this.mainActivityCode = mainActivityCode;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Address getCompanyAddress() {
        return this.companyAddress;
    }

    public void setCompanyAddress(Address companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getCompanyFixedPhone() {
        return this.companyFixedPhone;
    }

    public void setCompanyFixedPhone(String companyFixedPhone) {
        this.companyFixedPhone = companyFixedPhone;
    }

    public String getHealthService() {
        return this.healthService;
    }

    public void setHealthService(String healthService) {
        this.healthService = healthService;
    }

    public Address getHealthServiceAddress() {
        return this.healthServiceAddress;
    }

    public void setHealthServiceAddress(Address healthServiceAddress) {
        this.healthServiceAddress = healthServiceAddress;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public String getSexSelect() {
        return this.sexSelect;
    }

    public void setSexSelect(String sexSelect) {
        this.sexSelect = sexSelect;
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public Department getDepartmentOfBirth() {
        return this.departmentOfBirth;
    }

    public void setDepartmentOfBirth(Department departmentOfBirth) {
        this.departmentOfBirth = departmentOfBirth;
    }

    public City getCityOfBirth() {
        return this.cityOfBirth;
    }

    public void setCityOfBirth(City cityOfBirth) {
        this.cityOfBirth = cityOfBirth;
    }

    public Country getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(Country countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    public LocalDate getHireDate() {
        return this.hireDate;
    }

    public void setHireDate(LocalDate hireDate) {
        this.hireDate = hireDate;
    }

    public LocalTime getHireTime() {
        return this.hireTime;
    }

    public void setHireTime(LocalTime hireTime) {
        this.hireTime = hireTime;
    }

    public String getTrialPeriodDuration() {
        return this.trialPeriodDuration;
    }

    public void setTrialPeriodDuration(String trialPeriodDuration) {
        this.trialPeriodDuration = trialPeriodDuration;
    }

    public EmploymentContractType getContractType() {
        return this.contractType;
    }

    public void setContractType(EmploymentContractType contractType) {
        this.contractType = contractType;
    }

    public LocalDate getContractEndDate() {
        return this.contractEndDate;
    }

    public void setContractEndDate(LocalDate contractEndDate) {
        this.contractEndDate = contractEndDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DPAE)) {
            return false;
        }
        DPAE other = (DPAE)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("registrationCode", (Object)this.getRegistrationCode()).add("mainActivityCode", (Object)this.getMainActivityCode()).add("companyFixedPhone", (Object)this.getCompanyFixedPhone()).add("healthService", (Object)this.getHealthService()).add("lastName", (Object)this.getLastName()).add("firstName", (Object)this.getFirstName()).add("socialSecurityNumber", (Object)this.getSocialSecurityNumber()).add("sexSelect", (Object)this.getSexSelect()).add("birthDate", (Object)this.getBirthDate()).add("hireDate", (Object)this.getHireDate()).add("hireTime", (Object)this.getHireTime()).omitNullValues().toString();
    }
}

