/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Citizenship;
import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Department;
import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.hr.db.DPAE;
import com.axelor.apps.hr.db.EmployeeAdvance;
import com.axelor.apps.hr.db.EmployeeFile;
import com.axelor.apps.hr.db.EmployeeVehicle;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.KilometricLog;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LunchVoucherAdvance;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.db.converters.EncryptedStringConverter;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="HR_EMPLOYEE", indexes={@Index(columnList="contact_partner"), @Index(columnList="manager_user"), @Index(columnList="weekly_planning"), @Index(columnList="product"), @Index(columnList="public_holiday_events_planning"), @Index(columnList="city_of_birth"), @Index(columnList="citizenship"), @Index(columnList="department_of_birth"), @Index(columnList="country_of_birth"), @Index(columnList="main_employment_contract"), @Index(columnList="imposed_day_events_planning"), @Index(columnList="name")})
@Track(fields={@TrackField(name="fixedProPhone", on={TrackEvent.UPDATE}), @TrackField(name="mobileProPhone", on={TrackEvent.UPDATE}), @TrackField(name="phoneAtCustomer", on={TrackEvent.UPDATE}), @TrackField(name="managerUser", on={TrackEvent.UPDATE}), @TrackField(name="exportCode", on={TrackEvent.UPDATE}), @TrackField(name="weeklyPlanning", on={TrackEvent.UPDATE}), @TrackField(name="hrManager", on={TrackEvent.UPDATE}), @TrackField(name="external", on={TrackEvent.UPDATE}), @TrackField(name="bonusCoef", on={TrackEvent.UPDATE}), @TrackField(name="negativeValueLeave", on={TrackEvent.UPDATE}), @TrackField(name="lunchVoucherFormatSelect", on={TrackEvent.UPDATE}), @TrackField(name="companyCbSelect", on={TrackEvent.UPDATE})})
public class Employee
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYEE_SEQ")
    @SequenceGenerator(name="HR_EMPLOYEE_SEQ", sequenceName="HR_EMPLOYEE_SEQ", allocationSize=1)
    private Long id;
    @JoinColumn(name="user_id")
    @OneToOne(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Contact")
    @NotNull
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner contactPartner;
    @Widget(title="Hourly rate")
    @Digits(integer=18, fraction=2)
    private BigDecimal hourlyRate = BigDecimal.ZERO;
    @Widget(title="Time logging preference", selection="hr.time.logging.preference.select", massUpdate=true)
    private String timeLoggingPreferenceSelect;
    @Widget(title="Weekly work hours")
    @Digits(integer=18, fraction=2)
    private BigDecimal weeklyWorkHours = BigDecimal.ZERO;
    @Widget(title="Daily work hours")
    @Digits(integer=18, fraction=2)
    private BigDecimal dailyWorkHours = BigDecimal.ZERO;
    @Widget(title="Manager", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User managerUser;
    @Widget(title="Timesheet reminder")
    private Boolean timesheetReminder = Boolean.FALSE;
    @Widget(title="External")
    private Boolean external = Boolean.FALSE;
    @Widget(massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WeeklyPlanning weeklyPlanning;
    @Widget(title="Leave List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LeaveLine> leaveLineList;
    @Widget(title="Allow negative value for leaves")
    private Boolean negativeValueLeave = Boolean.FALSE;
    @Widget(title="Default Activity Product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product product;
    @Widget(title="Public Holiday Planning", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EventsPlanning publicHolidayEventsPlanning;
    @Widget(title="Employment contracts")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EmploymentContract> employmentContractList;
    @Widget(title="HR manager")
    private Boolean hrManager = Boolean.FALSE;
    @Widget(title="Batches")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Birth date")
    private LocalDate birthDate;
    @Widget(title="Marital status", selection="hr.employee.marital.status")
    private String maritalStatus;
    @Widget(title="City of birth")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private City cityOfBirth;
    @Widget(title="Citizenship")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Citizenship citizenship;
    @Widget(title="Department of birth", help="For foreign-born employees, please enter the code 99")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Department departmentOfBirth;
    @Widget(title="Country of birth")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Country countryOfBirth;
    @Widget(title="Sex", selection="employee.hr.sex.select")
    private String sexSelect;
    @Widget(title="Work fixed phone")
    private String fixedProPhone;
    @Widget(title="Work mobile phone")
    private String mobileProPhone;
    @Widget(title="Phone at the customer")
    private String phoneAtCustomer;
    @Widget(title="Emergency contact")
    private String emergencyContact;
    @Widget(title="Phone")
    private String emergencyNumber;
    @Widget(title="Emergency contact relationship")
    private String emergencyContactRelationship;
    @Widget(title="Date of hire")
    private LocalDate hireDate;
    @Widget(title="Seniority date")
    private LocalDate seniorityDate;
    @Widget(title="Main employment contract")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmploymentContract mainEmploymentContract;
    @Widget(title="Profit-sharing beneficiary", massUpdate=true)
    private Boolean profitSharingBeneficiary = Boolean.FALSE;
    @Widget(title="Imposed day Planning", massUpdate=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EventsPlanning imposedDayEventsPlanning;
    @Widget(title="Social security number")
    @Convert(converter=EncryptedStringConverter.class)
    private String socialSecurityNumber;
    @Widget(title="Employee advances", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EmployeeAdvance> employeeAdvanceList;
    @Widget(title="Lunch Voucher Format", selection="hr.lunch.voucher.mgt.line.lunch.voucher.format.select", massUpdate=true)
    private Integer lunchVoucherFormatSelect = 0;
    @Widget(title="Lunch voucher advances")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LunchVoucherAdvance> lunchVoucherAdvanceList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<KilometricLog> kilometricLogList;
    @Widget(title="Coefficient for bonus")
    private BigDecimal bonusCoef = BigDecimal.ZERO;
    @Widget(title="Export code")
    private String exportCode;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EmployeeVehicle> employeeVehicleList;
    @Widget(title="Expense paid with company's credit card", selection="hr.expense.company.cb.payment")
    private Integer companyCbSelect = 1;
    @Widget(title="Company credit card details")
    private String companyCbDetails;
    @Widget(title="Name", search={"contactPartner"})
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Step by step", selection="hr.employee.form.step.by.step.select")
    private Integer stepByStepSelect = 1;
    @Widget(title="DPAEs")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DPAE> dpaeList;
    @Widget(title="Files")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employee", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EmployeeFile> employeeFileList;
    @Widget(title="Maiden name")
    private String maidenName;
    @Widget(title="Marital name")
    private String maritalName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Employee() {
    }

    public Employee(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        if (this.getUser() != null) {
            this.getUser().setEmployee(null);
        }
        if (user != null) {
            user.setEmployee(this);
        }
        this.user = user;
    }

    public Partner getContactPartner() {
        return this.contactPartner;
    }

    public void setContactPartner(Partner contactPartner) {
        this.contactPartner = contactPartner;
    }

    public BigDecimal getHourlyRate() {
        return this.hourlyRate == null ? BigDecimal.ZERO : this.hourlyRate;
    }

    public void setHourlyRate(BigDecimal hourlyRate) {
        this.hourlyRate = hourlyRate;
    }

    public String getTimeLoggingPreferenceSelect() {
        return this.timeLoggingPreferenceSelect;
    }

    public void setTimeLoggingPreferenceSelect(String timeLoggingPreferenceSelect) {
        this.timeLoggingPreferenceSelect = timeLoggingPreferenceSelect;
    }

    public BigDecimal getWeeklyWorkHours() {
        return this.weeklyWorkHours == null ? BigDecimal.ZERO : this.weeklyWorkHours;
    }

    public void setWeeklyWorkHours(BigDecimal weeklyWorkHours) {
        this.weeklyWorkHours = weeklyWorkHours;
    }

    public BigDecimal getDailyWorkHours() {
        return this.dailyWorkHours == null ? BigDecimal.ZERO : this.dailyWorkHours;
    }

    public void setDailyWorkHours(BigDecimal dailyWorkHours) {
        this.dailyWorkHours = dailyWorkHours;
    }

    public User getManagerUser() {
        return this.managerUser;
    }

    public void setManagerUser(User managerUser) {
        this.managerUser = managerUser;
    }

    public Boolean getTimesheetReminder() {
        return this.timesheetReminder == null ? Boolean.FALSE : this.timesheetReminder;
    }

    public void setTimesheetReminder(Boolean timesheetReminder) {
        this.timesheetReminder = timesheetReminder;
    }

    public Boolean getExternal() {
        return this.external == null ? Boolean.FALSE : this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
    }

    public WeeklyPlanning getWeeklyPlanning() {
        return this.weeklyPlanning;
    }

    public void setWeeklyPlanning(WeeklyPlanning weeklyPlanning) {
        this.weeklyPlanning = weeklyPlanning;
    }

    public List<LeaveLine> getLeaveLineList() {
        return this.leaveLineList;
    }

    public void setLeaveLineList(List<LeaveLine> leaveLineList) {
        this.leaveLineList = leaveLineList;
    }

    public void addLeaveLineListItem(LeaveLine item) {
        if (this.getLeaveLineList() == null) {
            this.setLeaveLineList(new ArrayList<LeaveLine>());
        }
        this.getLeaveLineList().add(item);
        item.setEmployee(this);
    }

    public void removeLeaveLineListItem(LeaveLine item) {
        if (this.getLeaveLineList() == null) {
            return;
        }
        this.getLeaveLineList().remove((Object)item);
    }

    public void clearLeaveLineList() {
        if (this.getLeaveLineList() != null) {
            this.getLeaveLineList().clear();
        }
    }

    public Boolean getNegativeValueLeave() {
        return this.negativeValueLeave == null ? Boolean.FALSE : this.negativeValueLeave;
    }

    public void setNegativeValueLeave(Boolean negativeValueLeave) {
        this.negativeValueLeave = negativeValueLeave;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public EventsPlanning getPublicHolidayEventsPlanning() {
        return this.publicHolidayEventsPlanning;
    }

    public void setPublicHolidayEventsPlanning(EventsPlanning publicHolidayEventsPlanning) {
        this.publicHolidayEventsPlanning = publicHolidayEventsPlanning;
    }

    public List<EmploymentContract> getEmploymentContractList() {
        return this.employmentContractList;
    }

    public void setEmploymentContractList(List<EmploymentContract> employmentContractList) {
        this.employmentContractList = employmentContractList;
    }

    public void addEmploymentContractListItem(EmploymentContract item) {
        if (this.getEmploymentContractList() == null) {
            this.setEmploymentContractList(new ArrayList<EmploymentContract>());
        }
        this.getEmploymentContractList().add(item);
        item.setEmployee(this);
    }

    public void removeEmploymentContractListItem(EmploymentContract item) {
        if (this.getEmploymentContractList() == null) {
            return;
        }
        this.getEmploymentContractList().remove((Object)item);
    }

    public void clearEmploymentContractList() {
        if (this.getEmploymentContractList() != null) {
            this.getEmploymentContractList().clear();
        }
    }

    public Boolean getHrManager() {
        return this.hrManager == null ? Boolean.FALSE : this.hrManager;
    }

    public void setHrManager(Boolean hrManager) {
        this.hrManager = hrManager;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public LocalDate getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public City getCityOfBirth() {
        return this.cityOfBirth;
    }

    public void setCityOfBirth(City cityOfBirth) {
        this.cityOfBirth = cityOfBirth;
    }

    public Citizenship getCitizenship() {
        return this.citizenship;
    }

    public void setCitizenship(Citizenship citizenship) {
        this.citizenship = citizenship;
    }

    public Department getDepartmentOfBirth() {
        return this.departmentOfBirth;
    }

    public void setDepartmentOfBirth(Department departmentOfBirth) {
        this.departmentOfBirth = departmentOfBirth;
    }

    public Country getCountryOfBirth() {
        return this.countryOfBirth;
    }

    public void setCountryOfBirth(Country countryOfBirth) {
        this.countryOfBirth = countryOfBirth;
    }

    public String getSexSelect() {
        return this.sexSelect;
    }

    public void setSexSelect(String sexSelect) {
        this.sexSelect = sexSelect;
    }

    public String getFixedProPhone() {
        return this.fixedProPhone;
    }

    public void setFixedProPhone(String fixedProPhone) {
        this.fixedProPhone = fixedProPhone;
    }

    public String getMobileProPhone() {
        return this.mobileProPhone;
    }

    public void setMobileProPhone(String mobileProPhone) {
        this.mobileProPhone = mobileProPhone;
    }

    public String getPhoneAtCustomer() {
        return this.phoneAtCustomer;
    }

    public void setPhoneAtCustomer(String phoneAtCustomer) {
        this.phoneAtCustomer = phoneAtCustomer;
    }

    public String getEmergencyContact() {
        return this.emergencyContact;
    }

    public void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact;
    }

    public String getEmergencyNumber() {
        return this.emergencyNumber;
    }

    public void setEmergencyNumber(String emergencyNumber) {
        this.emergencyNumber = emergencyNumber;
    }

    public String getEmergencyContactRelationship() {
        return this.emergencyContactRelationship;
    }

    public void setEmergencyContactRelationship(String emergencyContactRelationship) {
        this.emergencyContactRelationship = emergencyContactRelationship;
    }

    public LocalDate getHireDate() {
        return this.hireDate;
    }

    public void setHireDate(LocalDate hireDate) {
        this.hireDate = hireDate;
    }

    public LocalDate getSeniorityDate() {
        return this.seniorityDate;
    }

    public void setSeniorityDate(LocalDate seniorityDate) {
        this.seniorityDate = seniorityDate;
    }

    public EmploymentContract getMainEmploymentContract() {
        return this.mainEmploymentContract;
    }

    public void setMainEmploymentContract(EmploymentContract mainEmploymentContract) {
        this.mainEmploymentContract = mainEmploymentContract;
    }

    public Boolean getProfitSharingBeneficiary() {
        return this.profitSharingBeneficiary == null ? Boolean.FALSE : this.profitSharingBeneficiary;
    }

    public void setProfitSharingBeneficiary(Boolean profitSharingBeneficiary) {
        this.profitSharingBeneficiary = profitSharingBeneficiary;
    }

    public EventsPlanning getImposedDayEventsPlanning() {
        return this.imposedDayEventsPlanning;
    }

    public void setImposedDayEventsPlanning(EventsPlanning imposedDayEventsPlanning) {
        this.imposedDayEventsPlanning = imposedDayEventsPlanning;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public List<EmployeeAdvance> getEmployeeAdvanceList() {
        return this.employeeAdvanceList;
    }

    public void setEmployeeAdvanceList(List<EmployeeAdvance> employeeAdvanceList) {
        this.employeeAdvanceList = employeeAdvanceList;
    }

    public void addEmployeeAdvanceListItem(EmployeeAdvance item) {
        if (this.getEmployeeAdvanceList() == null) {
            this.setEmployeeAdvanceList(new ArrayList<EmployeeAdvance>());
        }
        this.getEmployeeAdvanceList().add(item);
        item.setEmployee(this);
    }

    public void removeEmployeeAdvanceListItem(EmployeeAdvance item) {
        if (this.getEmployeeAdvanceList() == null) {
            return;
        }
        this.getEmployeeAdvanceList().remove((Object)item);
    }

    public void clearEmployeeAdvanceList() {
        if (this.getEmployeeAdvanceList() != null) {
            this.getEmployeeAdvanceList().clear();
        }
    }

    public Integer getLunchVoucherFormatSelect() {
        return this.lunchVoucherFormatSelect == null ? 0 : this.lunchVoucherFormatSelect;
    }

    public void setLunchVoucherFormatSelect(Integer lunchVoucherFormatSelect) {
        this.lunchVoucherFormatSelect = lunchVoucherFormatSelect;
    }

    public List<LunchVoucherAdvance> getLunchVoucherAdvanceList() {
        return this.lunchVoucherAdvanceList;
    }

    public void setLunchVoucherAdvanceList(List<LunchVoucherAdvance> lunchVoucherAdvanceList) {
        this.lunchVoucherAdvanceList = lunchVoucherAdvanceList;
    }

    public void addLunchVoucherAdvanceListItem(LunchVoucherAdvance item) {
        if (this.getLunchVoucherAdvanceList() == null) {
            this.setLunchVoucherAdvanceList(new ArrayList<LunchVoucherAdvance>());
        }
        this.getLunchVoucherAdvanceList().add(item);
        item.setEmployee(this);
    }

    public void removeLunchVoucherAdvanceListItem(LunchVoucherAdvance item) {
        if (this.getLunchVoucherAdvanceList() == null) {
            return;
        }
        this.getLunchVoucherAdvanceList().remove((Object)item);
    }

    public void clearLunchVoucherAdvanceList() {
        if (this.getLunchVoucherAdvanceList() != null) {
            this.getLunchVoucherAdvanceList().clear();
        }
    }

    public List<KilometricLog> getKilometricLogList() {
        return this.kilometricLogList;
    }

    public void setKilometricLogList(List<KilometricLog> kilometricLogList) {
        this.kilometricLogList = kilometricLogList;
    }

    public void addKilometricLogListItem(KilometricLog item) {
        if (this.getKilometricLogList() == null) {
            this.setKilometricLogList(new ArrayList<KilometricLog>());
        }
        this.getKilometricLogList().add(item);
        item.setEmployee(this);
    }

    public void removeKilometricLogListItem(KilometricLog item) {
        if (this.getKilometricLogList() == null) {
            return;
        }
        this.getKilometricLogList().remove((Object)item);
    }

    public void clearKilometricLogList() {
        if (this.getKilometricLogList() != null) {
            this.getKilometricLogList().clear();
        }
    }

    public BigDecimal getBonusCoef() {
        return this.bonusCoef == null ? BigDecimal.ZERO : this.bonusCoef;
    }

    public void setBonusCoef(BigDecimal bonusCoef) {
        this.bonusCoef = bonusCoef;
    }

    public String getExportCode() {
        return this.exportCode;
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public List<EmployeeVehicle> getEmployeeVehicleList() {
        return this.employeeVehicleList;
    }

    public void setEmployeeVehicleList(List<EmployeeVehicle> employeeVehicleList) {
        this.employeeVehicleList = employeeVehicleList;
    }

    public void addEmployeeVehicleListItem(EmployeeVehicle item) {
        if (this.getEmployeeVehicleList() == null) {
            this.setEmployeeVehicleList(new ArrayList<EmployeeVehicle>());
        }
        this.getEmployeeVehicleList().add(item);
        item.setEmployee(this);
    }

    public void removeEmployeeVehicleListItem(EmployeeVehicle item) {
        if (this.getEmployeeVehicleList() == null) {
            return;
        }
        this.getEmployeeVehicleList().remove((Object)item);
    }

    public void clearEmployeeVehicleList() {
        if (this.getEmployeeVehicleList() != null) {
            this.getEmployeeVehicleList().clear();
        }
    }

    public Integer getCompanyCbSelect() {
        return this.companyCbSelect == null ? 0 : this.companyCbSelect;
    }

    public void setCompanyCbSelect(Integer companyCbSelect) {
        this.companyCbSelect = companyCbSelect;
    }

    public String getCompanyCbDetails() {
        return this.companyCbDetails;
    }

    public void setCompanyCbDetails(String companyCbDetails) {
        this.companyCbDetails = companyCbDetails;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        if (this.contactPartner != null && this.contactPartner.getFullName() != null) {
            return this.contactPartner.getFullName();
        }
        return "";
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStepByStepSelect() {
        return this.stepByStepSelect == null ? 0 : this.stepByStepSelect;
    }

    public void setStepByStepSelect(Integer stepByStepSelect) {
        this.stepByStepSelect = stepByStepSelect;
    }

    public List<DPAE> getDpaeList() {
        return this.dpaeList;
    }

    public void setDpaeList(List<DPAE> dpaeList) {
        this.dpaeList = dpaeList;
    }

    public void addDpaeListItem(DPAE item) {
        if (this.getDpaeList() == null) {
            this.setDpaeList(new ArrayList<DPAE>());
        }
        this.getDpaeList().add(item);
        item.setEmployee(this);
    }

    public void removeDpaeListItem(DPAE item) {
        if (this.getDpaeList() == null) {
            return;
        }
        this.getDpaeList().remove((Object)item);
    }

    public void clearDpaeList() {
        if (this.getDpaeList() != null) {
            this.getDpaeList().clear();
        }
    }

    public List<EmployeeFile> getEmployeeFileList() {
        return this.employeeFileList;
    }

    public void setEmployeeFileList(List<EmployeeFile> employeeFileList) {
        this.employeeFileList = employeeFileList;
    }

    public void addEmployeeFileListItem(EmployeeFile item) {
        if (this.getEmployeeFileList() == null) {
            this.setEmployeeFileList(new ArrayList<EmployeeFile>());
        }
        this.getEmployeeFileList().add(item);
        item.setEmployee(this);
    }

    public void removeEmployeeFileListItem(EmployeeFile item) {
        if (this.getEmployeeFileList() == null) {
            return;
        }
        this.getEmployeeFileList().remove((Object)item);
    }

    public void clearEmployeeFileList() {
        if (this.getEmployeeFileList() != null) {
            this.getEmployeeFileList().clear();
        }
    }

    public String getMaidenName() {
        return this.maidenName;
    }

    public void setMaidenName(String maidenName) {
        this.maidenName = maidenName;
    }

    public String getMaritalName() {
        return this.maritalName;
    }

    public void setMaritalName(String maritalName) {
        this.maritalName = maritalName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Employee)) {
            return false;
        }
        Employee other = (Employee)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("hourlyRate", (Object)this.getHourlyRate()).add("timeLoggingPreferenceSelect", (Object)this.getTimeLoggingPreferenceSelect()).add("weeklyWorkHours", (Object)this.getWeeklyWorkHours()).add("dailyWorkHours", (Object)this.getDailyWorkHours()).add("timesheetReminder", (Object)this.getTimesheetReminder()).add("external", (Object)this.getExternal()).add("negativeValueLeave", (Object)this.getNegativeValueLeave()).add("hrManager", (Object)this.getHrManager()).add("birthDate", (Object)this.getBirthDate()).add("maritalStatus", (Object)this.getMaritalStatus()).add("sexSelect", (Object)this.getSexSelect()).omitNullValues().toString();
    }
}

