/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.hr.db.EmployeeBonusMgtLine;
import com.axelor.apps.hr.db.EmployeeBonusType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_EMPLOYEE_BONUS_MGT", indexes={@Index(columnList="company"), @Index(columnList="pay_period"), @Index(columnList="leave_period"), @Index(columnList="employee_bonus_type")})
public class EmployeeBonusMgt
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYEE_BONUS_MGT_SEQ")
    @SequenceGenerator(name="HR_EMPLOYEE_BONUS_MGT_SEQ", sequenceName="HR_EMPLOYEE_BONUS_MGT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Pay period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period payPeriod;
    @Widget(title="Leave period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period leavePeriod;
    @Widget(title="Bonus type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmployeeBonusType employeeBonusType;
    @Widget(title="Status", readonly=true, selection="hr.employee.bonus.mgt.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Base amount per employee")
    private BigDecimal baseAmount = BigDecimal.ZERO;
    @Widget(title="Employee bonus")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="employeeBonusMgt", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EmployeeBonusMgtLine> employeeBonusMgtLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Period getPayPeriod() {
        return this.payPeriod;
    }

    public void setPayPeriod(Period payPeriod) {
        this.payPeriod = payPeriod;
    }

    public Period getLeavePeriod() {
        return this.leavePeriod;
    }

    public void setLeavePeriod(Period leavePeriod) {
        this.leavePeriod = leavePeriod;
    }

    public EmployeeBonusType getEmployeeBonusType() {
        return this.employeeBonusType;
    }

    public void setEmployeeBonusType(EmployeeBonusType employeeBonusType) {
        this.employeeBonusType = employeeBonusType;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public BigDecimal getBaseAmount() {
        return this.baseAmount == null ? BigDecimal.ZERO : this.baseAmount;
    }

    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public List<EmployeeBonusMgtLine> getEmployeeBonusMgtLineList() {
        return this.employeeBonusMgtLineList;
    }

    public void setEmployeeBonusMgtLineList(List<EmployeeBonusMgtLine> employeeBonusMgtLineList) {
        this.employeeBonusMgtLineList = employeeBonusMgtLineList;
    }

    public void addEmployeeBonusMgtLineListItem(EmployeeBonusMgtLine item) {
        if (this.getEmployeeBonusMgtLineList() == null) {
            this.setEmployeeBonusMgtLineList(new ArrayList<EmployeeBonusMgtLine>());
        }
        this.getEmployeeBonusMgtLineList().add(item);
        item.setEmployeeBonusMgt(this);
    }

    public void removeEmployeeBonusMgtLineListItem(EmployeeBonusMgtLine item) {
        if (this.getEmployeeBonusMgtLineList() == null) {
            return;
        }
        this.getEmployeeBonusMgtLineList().remove((Object)item);
    }

    public void clearEmployeeBonusMgtLineList() {
        if (this.getEmployeeBonusMgtLineList() != null) {
            this.getEmployeeBonusMgtLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmployeeBonusMgt)) {
            return false;
        }
        EmployeeBonusMgt other = (EmployeeBonusMgt)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("baseAmount", (Object)this.getBaseAmount()).omitNullValues().toString();
    }
}

