/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeBonusMgt;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_EMPLOYEE_BONUS_MGT_LINE", indexes={@Index(columnList="employee"), @Index(columnList="weekly_planning"), @Index(columnList="employee_bonus_mgt"), @Index(columnList="payroll_preparation")})
public class EmployeeBonusMgtLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYEE_BONUS_MGT_LINE_SEQ")
    @SequenceGenerator(name="HR_EMPLOYEE_BONUS_MGT_LINE_SEQ", sequenceName="HR_EMPLOYEE_BONUS_MGT_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="Bonus coefficient")
    private BigDecimal coef = BigDecimal.ZERO;
    @Widget(title="Presence")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private WeeklyPlanning weeklyPlanning;
    @Widget(title="Seniority date")
    private LocalDate seniorityDate;
    @Widget(title="Employee bonus mgt")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmployeeBonusMgt employeeBonusMgt;
    @Widget(title="Payroll preparation")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PayrollPreparation payrollPreparation;
    @Widget(title="Status", readonly=true, selection="hr.employee.bonus.mgt.line.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getCoef() {
        return this.coef == null ? BigDecimal.ZERO : this.coef;
    }

    public void setCoef(BigDecimal coef) {
        this.coef = coef;
    }

    public WeeklyPlanning getWeeklyPlanning() {
        return this.weeklyPlanning;
    }

    public void setWeeklyPlanning(WeeklyPlanning weeklyPlanning) {
        this.weeklyPlanning = weeklyPlanning;
    }

    public LocalDate getSeniorityDate() {
        return this.seniorityDate;
    }

    public void setSeniorityDate(LocalDate seniorityDate) {
        this.seniorityDate = seniorityDate;
    }

    public EmployeeBonusMgt getEmployeeBonusMgt() {
        return this.employeeBonusMgt;
    }

    public void setEmployeeBonusMgt(EmployeeBonusMgt employeeBonusMgt) {
        this.employeeBonusMgt = employeeBonusMgt;
    }

    public PayrollPreparation getPayrollPreparation() {
        return this.payrollPreparation;
    }

    public void setPayrollPreparation(PayrollPreparation payrollPreparation) {
        this.payrollPreparation = payrollPreparation;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmployeeBonusMgtLine)) {
            return false;
        }
        EmployeeBonusMgtLine other = (EmployeeBonusMgtLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("amount", (Object)this.getAmount()).add("coef", (Object)this.getCoef()).add("seniorityDate", (Object)this.getSeniorityDate()).add("statusSelect", (Object)this.getStatusSelect()).omitNullValues().toString();
    }
}

