/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.CompanyDepartment;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContractTemplate;
import com.axelor.apps.hr.db.EmploymentContractType;
import com.axelor.apps.hr.db.EndOfContractReason;
import com.axelor.apps.hr.db.OtherCostsEmployee;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="HR_EMPLOYMENT_CONTRACT", indexes={@Index(columnList="employee"), @Index(columnList="pay_company"), @Index(columnList="company_department"), @Index(columnList="contract_type"), @Index(columnList="end_of_contract_reason"), @Index(columnList="employment_contract_template"), @Index(columnList="fullName")})
public class EmploymentContract
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYMENT_CONTRACT_SEQ")
    @SequenceGenerator(name="HR_EMPLOYMENT_CONTRACT_SEQ", sequenceName="HR_EMPLOYMENT_CONTRACT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Ref.")
    private String ref;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Pay Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company payCompany;
    @Widget(title="Company department")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CompanyDepartment companyDepartment;
    @Widget(title="Amendment")
    private Integer employmentContractVersion = 0;
    @Widget(title="Amendment type", selection="hr.employment.contract.amendment.type.select")
    private Integer amendmentTypeSelect = 0;
    @Widget(title="Amendment Date")
    private LocalDate amendmentDate;
    @Widget(title="Status", selection="hr.employment.contract.status")
    private Integer status = 0;
    @Widget(title="Contract type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmploymentContractType contractType;
    @Widget(title="Start date")
    private LocalDate startDate;
    @Widget(title="End date")
    private LocalDate endDate;
    @Widget(title="Start time")
    private LocalTime startTime;
    @Widget(title="Duration")
    private String duration;
    @Widget(title="Trial period duration")
    private String trialPeriodDuration;
    @Widget(title="Position")
    private String position;
    @Widget(title="Coefficient")
    private String coefficient;
    @Widget(title="Weekly duration")
    private BigDecimal weeklyDuration = BigDecimal.ZERO;
    @Widget(title="Hourly gross salary")
    private BigDecimal hourlyGrossSalary = BigDecimal.ZERO;
    @Widget(title="Details")
    private String endContractDetails;
    @Widget(title="End of contract reason")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EndOfContractReason endOfContractReason;
    @Widget(title="Signature date")
    private LocalDate signatureDate;
    @Widget(title="Hours distribution")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String hoursDistribution;
    @Widget(title="Executive Status", selection="hr.employment.contract.executiveStatus.select")
    private Integer executiveStatusSelect = 0;
    @Widget(title="Min monthly remuneration")
    private BigDecimal minMonthlyRemuneration = BigDecimal.ZERO;
    @Widget(title="Employment contract template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmploymentContractTemplate employmentContractTemplate;
    @Widget(title="Employment")
    private String employment;
    @Widget(title="Annual gross salary")
    private BigDecimal annualGrossSalary = BigDecimal.ZERO;
    @Widget(title="Monthly global cost")
    private BigDecimal monthlyGlobalCost = BigDecimal.ZERO;
    @Widget(title="Others")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<OtherCostsEmployee> otherCostsEmployeeSet;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Company getPayCompany() {
        return this.payCompany;
    }

    public void setPayCompany(Company payCompany) {
        this.payCompany = payCompany;
    }

    public CompanyDepartment getCompanyDepartment() {
        return this.companyDepartment;
    }

    public void setCompanyDepartment(CompanyDepartment companyDepartment) {
        this.companyDepartment = companyDepartment;
    }

    public Integer getEmploymentContractVersion() {
        return this.employmentContractVersion == null ? 0 : this.employmentContractVersion;
    }

    public void setEmploymentContractVersion(Integer employmentContractVersion) {
        this.employmentContractVersion = employmentContractVersion;
    }

    public Integer getAmendmentTypeSelect() {
        return this.amendmentTypeSelect == null ? 0 : this.amendmentTypeSelect;
    }

    public void setAmendmentTypeSelect(Integer amendmentTypeSelect) {
        this.amendmentTypeSelect = amendmentTypeSelect;
    }

    public LocalDate getAmendmentDate() {
        return this.amendmentDate;
    }

    public void setAmendmentDate(LocalDate amendmentDate) {
        this.amendmentDate = amendmentDate;
    }

    public Integer getStatus() {
        return this.status == null ? 0 : this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public EmploymentContractType getContractType() {
        return this.contractType;
    }

    public void setContractType(EmploymentContractType contractType) {
        this.contractType = contractType;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalTime startTime) {
        this.startTime = startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getTrialPeriodDuration() {
        return this.trialPeriodDuration;
    }

    public void setTrialPeriodDuration(String trialPeriodDuration) {
        this.trialPeriodDuration = trialPeriodDuration;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getCoefficient() {
        return this.coefficient;
    }

    public void setCoefficient(String coefficient) {
        this.coefficient = coefficient;
    }

    public BigDecimal getWeeklyDuration() {
        return this.weeklyDuration == null ? BigDecimal.ZERO : this.weeklyDuration;
    }

    public void setWeeklyDuration(BigDecimal weeklyDuration) {
        this.weeklyDuration = weeklyDuration;
    }

    public BigDecimal getHourlyGrossSalary() {
        return this.hourlyGrossSalary == null ? BigDecimal.ZERO : this.hourlyGrossSalary;
    }

    public void setHourlyGrossSalary(BigDecimal hourlyGrossSalary) {
        this.hourlyGrossSalary = hourlyGrossSalary;
    }

    public String getEndContractDetails() {
        return this.endContractDetails;
    }

    public void setEndContractDetails(String endContractDetails) {
        this.endContractDetails = endContractDetails;
    }

    public EndOfContractReason getEndOfContractReason() {
        return this.endOfContractReason;
    }

    public void setEndOfContractReason(EndOfContractReason endOfContractReason) {
        this.endOfContractReason = endOfContractReason;
    }

    public LocalDate getSignatureDate() {
        return this.signatureDate;
    }

    public void setSignatureDate(LocalDate signatureDate) {
        this.signatureDate = signatureDate;
    }

    public String getHoursDistribution() {
        return this.hoursDistribution;
    }

    public void setHoursDistribution(String hoursDistribution) {
        this.hoursDistribution = hoursDistribution;
    }

    public Integer getExecutiveStatusSelect() {
        return this.executiveStatusSelect == null ? 0 : this.executiveStatusSelect;
    }

    public void setExecutiveStatusSelect(Integer executiveStatusSelect) {
        this.executiveStatusSelect = executiveStatusSelect;
    }

    public BigDecimal getMinMonthlyRemuneration() {
        return this.minMonthlyRemuneration == null ? BigDecimal.ZERO : this.minMonthlyRemuneration;
    }

    public void setMinMonthlyRemuneration(BigDecimal minMonthlyRemuneration) {
        this.minMonthlyRemuneration = minMonthlyRemuneration;
    }

    public EmploymentContractTemplate getEmploymentContractTemplate() {
        return this.employmentContractTemplate;
    }

    public void setEmploymentContractTemplate(EmploymentContractTemplate employmentContractTemplate) {
        this.employmentContractTemplate = employmentContractTemplate;
    }

    public String getEmployment() {
        return this.employment;
    }

    public void setEmployment(String employment) {
        this.employment = employment;
    }

    public BigDecimal getAnnualGrossSalary() {
        return this.annualGrossSalary == null ? BigDecimal.ZERO : this.annualGrossSalary;
    }

    public void setAnnualGrossSalary(BigDecimal annualGrossSalary) {
        this.annualGrossSalary = annualGrossSalary;
    }

    public BigDecimal getMonthlyGlobalCost() {
        return this.monthlyGlobalCost == null ? BigDecimal.ZERO : this.monthlyGlobalCost;
    }

    public void setMonthlyGlobalCost(BigDecimal monthlyGlobalCost) {
        this.monthlyGlobalCost = monthlyGlobalCost;
    }

    public Set<OtherCostsEmployee> getOtherCostsEmployeeSet() {
        return this.otherCostsEmployeeSet;
    }

    public void setOtherCostsEmployeeSet(Set<OtherCostsEmployee> otherCostsEmployeeSet) {
        this.otherCostsEmployeeSet = otherCostsEmployeeSet;
    }

    public void addOtherCostsEmployeeSetItem(OtherCostsEmployee item) {
        if (this.getOtherCostsEmployeeSet() == null) {
            this.setOtherCostsEmployeeSet(new HashSet<OtherCostsEmployee>());
        }
        this.getOtherCostsEmployeeSet().add(item);
    }

    public void removeOtherCostsEmployeeSetItem(OtherCostsEmployee item) {
        if (this.getOtherCostsEmployeeSet() == null) {
            return;
        }
        this.getOtherCostsEmployeeSet().remove((Object)item);
    }

    public void clearOtherCostsEmployeeSet() {
        if (this.getOtherCostsEmployeeSet() != null) {
            this.getOtherCostsEmployeeSet().clear();
        }
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.contractType != null) {
            fullName = fullName + this.contractType.getName();
        }
        if (this.employee != null) {
            fullName = fullName + (fullName.isEmpty() ? "" : "-") + this.employee.getName();
        }
        if (this.startDate != null) {
            fullName = fullName + (fullName.isEmpty() ? "" : "-") + this.startDate.toString();
        }
        if (this.endDate != null) {
            fullName = fullName + (fullName.isEmpty() ? "" : "-") + this.endDate.toString();
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmploymentContract)) {
            return false;
        }
        EmploymentContract other = (EmploymentContract)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("ref", (Object)this.getRef()).add("employmentContractVersion", (Object)this.getEmploymentContractVersion()).add("amendmentTypeSelect", (Object)this.getAmendmentTypeSelect()).add("amendmentDate", (Object)this.getAmendmentDate()).add("status", (Object)this.getStatus()).add("startDate", (Object)this.getStartDate()).add("endDate", (Object)this.getEndDate()).add("startTime", (Object)this.getStartTime()).add("duration", (Object)this.getDuration()).add("trialPeriodDuration", (Object)this.getTrialPeriodDuration()).add("position", (Object)this.getPosition()).omitNullValues().toString();
    }
}

