/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_EMPLOYMENT_CONTRACT_TEMPLATE", indexes={@Index(columnList="meta_file")})
public class EmploymentContractTemplate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EMPLOYMENT_CONTRACT_TEMPLATE_SEQ")
    @SequenceGenerator(name="HR_EMPLOYMENT_CONTRACT_TEMPLATE_SEQ", sequenceName="HR_EMPLOYMENT_CONTRACT_TEMPLATE_SEQ", allocationSize=1)
    private Long id;
    @HashKey
    @Widget(title="Name")
    @NotNull
    @Column(unique=true)
    private String name;
    @Widget(title="Template")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Companies")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Company> companySet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EmploymentContractTemplate() {
    }

    public EmploymentContractTemplate(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Company> getCompanySet() {
        return this.companySet;
    }

    public void setCompanySet(Set<Company> companySet) {
        this.companySet = companySet;
    }

    public void addCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            this.setCompanySet(new HashSet<Company>());
        }
        this.getCompanySet().add(item);
    }

    public void removeCompanySetItem(Company item) {
        if (this.getCompanySet() == null) {
            return;
        }
        this.getCompanySet().remove((Object)item);
    }

    public void clearCompanySet() {
        if (this.getCompanySet() != null) {
            this.getCompanySet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmploymentContractTemplate)) {
            return false;
        }
        EmploymentContractTemplate other = (EmploymentContractTemplate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getName(), other.getName());
    }

    public int hashCode() {
        return Objects.hash(-1173537832, this.getName());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

