/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.hr.db.EmployeeAdvanceUsage;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Digits;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="HR_EXPENSE", uniqueConstraints={@UniqueConstraint(columnNames={"expenseSeq", "company"})}, indexes={@Index(columnList="period"), @Index(columnList="user_id"), @Index(columnList="company"), @Index(columnList="move"), @Index(columnList="validated_by"), @Index(columnList="refused_by"), @Index(columnList="payroll_preparation"), @Index(columnList="payment_mode"), @Index(columnList="bank_order"), @Index(columnList="payment_move"), @Index(columnList="fullName"), @Index(columnList="bank_details")})
public class Expense
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EXPENSE_SEQ")
    @SequenceGenerator(name="HR_EXPENSE_SEQ", sequenceName="HR_EXPENSE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Expense N\u00b0", readonly=true)
    private String expenseSeq;
    @Widget(title="Sent Date", readonly=true)
    private LocalDate sentDate;
    @Widget(title="Period")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Period period;
    @Widget(title="Status", readonly=true, selection="hrs.expenses.status.select")
    private Integer statusSelect = 1;
    @Widget(title="User", readonly=true)
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="General expense lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="generalExpense", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ExpenseLine> generalExpenseLineList;
    @Widget(title="Kilometric lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="kilometricExpense", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ExpenseLine> kilometricExpenseLineList;
    @Widget(title="Total W.T.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal exTaxTotal = BigDecimal.ZERO;
    @Widget(title="Total tax", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal taxTotal = BigDecimal.ZERO;
    @Widget(title="Total A.T.I.", readonly=true)
    @Digits(integer=18, fraction=2)
    private BigDecimal inTaxTotal = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Move Date")
    private LocalDate moveDate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move move;
    @Widget(title="Validated by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedBy;
    @Widget(title="Refused By", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User refusedBy;
    @Widget(title="Validation Date", readonly=true)
    private LocalDate validationDate;
    @Widget(title="Refusal Date", readonly=true)
    private LocalDate refusalDate;
    @Widget(title="Ground For Refusal")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String groundForRefusal;
    private Boolean ventilated = Boolean.FALSE;
    @Widget(title="Expense paid with company's credit card", selection="hr.expense.company.cb.payment")
    private Integer companyCbSelect = 1;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PayrollPreparation payrollPreparation;
    @Widget(title="Multiple users")
    private Boolean multipleUsers = Boolean.FALSE;
    @Widget(title="Employee advances", readonly=true)
    @OneToMany(fetch=FetchType.LAZY, mappedBy="expense", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<EmployeeAdvanceUsage> employeeAdvanceUsageList;
    @Widget(title="Advance")
    private BigDecimal advanceAmount = BigDecimal.ZERO;
    @Widget(title="Withdrawn cash")
    private BigDecimal withdrawnCash = BigDecimal.ZERO;
    @Widget(title="Personal expense amount", hidden=true)
    private BigDecimal personalExpenseAmount = BigDecimal.ZERO;
    @Widget(title="Payment Date", readonly=true)
    private LocalDate paymentDate;
    @Widget(title="Payment mode")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Bank Order", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrder bankOrder;
    @Widget(title="Payment amount", readonly=true)
    private BigDecimal paymentAmount = BigDecimal.ZERO;
    @Widget(title="Payment Status", readonly=true, selection="invoice.payment.status.select")
    private Integer paymentStatusSelect = 0;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move paymentMove;
    @Widget(readonly=true)
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Bank")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExpenseSeq() {
        return this.expenseSeq;
    }

    public void setExpenseSeq(String expenseSeq) {
        this.expenseSeq = expenseSeq;
    }

    public LocalDate getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(LocalDate sentDate) {
        this.sentDate = sentDate;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public List<ExpenseLine> getGeneralExpenseLineList() {
        return this.generalExpenseLineList;
    }

    public void setGeneralExpenseLineList(List<ExpenseLine> generalExpenseLineList) {
        this.generalExpenseLineList = generalExpenseLineList;
    }

    public void addGeneralExpenseLineListItem(ExpenseLine item) {
        if (this.getGeneralExpenseLineList() == null) {
            this.setGeneralExpenseLineList(new ArrayList<ExpenseLine>());
        }
        this.getGeneralExpenseLineList().add(item);
        item.setGeneralExpense(this);
    }

    public void removeGeneralExpenseLineListItem(ExpenseLine item) {
        if (this.getGeneralExpenseLineList() == null) {
            return;
        }
        this.getGeneralExpenseLineList().remove((Object)item);
    }

    public void clearGeneralExpenseLineList() {
        if (this.getGeneralExpenseLineList() != null) {
            this.getGeneralExpenseLineList().clear();
        }
    }

    public List<ExpenseLine> getKilometricExpenseLineList() {
        return this.kilometricExpenseLineList;
    }

    public void setKilometricExpenseLineList(List<ExpenseLine> kilometricExpenseLineList) {
        this.kilometricExpenseLineList = kilometricExpenseLineList;
    }

    public void addKilometricExpenseLineListItem(ExpenseLine item) {
        if (this.getKilometricExpenseLineList() == null) {
            this.setKilometricExpenseLineList(new ArrayList<ExpenseLine>());
        }
        this.getKilometricExpenseLineList().add(item);
        item.setKilometricExpense(this);
    }

    public void removeKilometricExpenseLineListItem(ExpenseLine item) {
        if (this.getKilometricExpenseLineList() == null) {
            return;
        }
        this.getKilometricExpenseLineList().remove((Object)item);
    }

    public void clearKilometricExpenseLineList() {
        if (this.getKilometricExpenseLineList() != null) {
            this.getKilometricExpenseLineList().clear();
        }
    }

    public BigDecimal getExTaxTotal() {
        return this.exTaxTotal == null ? BigDecimal.ZERO : this.exTaxTotal;
    }

    public void setExTaxTotal(BigDecimal exTaxTotal) {
        this.exTaxTotal = exTaxTotal;
    }

    public BigDecimal getTaxTotal() {
        return this.taxTotal == null ? BigDecimal.ZERO : this.taxTotal;
    }

    public void setTaxTotal(BigDecimal taxTotal) {
        this.taxTotal = taxTotal;
    }

    public BigDecimal getInTaxTotal() {
        return this.inTaxTotal == null ? BigDecimal.ZERO : this.inTaxTotal;
    }

    public void setInTaxTotal(BigDecimal inTaxTotal) {
        this.inTaxTotal = inTaxTotal;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public LocalDate getMoveDate() {
        return this.moveDate;
    }

    public void setMoveDate(LocalDate moveDate) {
        this.moveDate = moveDate;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public User getValidatedBy() {
        return this.validatedBy;
    }

    public void setValidatedBy(User validatedBy) {
        this.validatedBy = validatedBy;
    }

    public User getRefusedBy() {
        return this.refusedBy;
    }

    public void setRefusedBy(User refusedBy) {
        this.refusedBy = refusedBy;
    }

    public LocalDate getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(LocalDate validationDate) {
        this.validationDate = validationDate;
    }

    public LocalDate getRefusalDate() {
        return this.refusalDate;
    }

    public void setRefusalDate(LocalDate refusalDate) {
        this.refusalDate = refusalDate;
    }

    public String getGroundForRefusal() {
        return this.groundForRefusal;
    }

    public void setGroundForRefusal(String groundForRefusal) {
        this.groundForRefusal = groundForRefusal;
    }

    public Boolean getVentilated() {
        return this.ventilated == null ? Boolean.FALSE : this.ventilated;
    }

    public void setVentilated(Boolean ventilated) {
        this.ventilated = ventilated;
    }

    public Integer getCompanyCbSelect() {
        return this.companyCbSelect == null ? 0 : this.companyCbSelect;
    }

    public void setCompanyCbSelect(Integer companyCbSelect) {
        this.companyCbSelect = companyCbSelect;
    }

    public PayrollPreparation getPayrollPreparation() {
        return this.payrollPreparation;
    }

    public void setPayrollPreparation(PayrollPreparation payrollPreparation) {
        this.payrollPreparation = payrollPreparation;
    }

    public Boolean getMultipleUsers() {
        return this.multipleUsers == null ? Boolean.FALSE : this.multipleUsers;
    }

    public void setMultipleUsers(Boolean multipleUsers) {
        this.multipleUsers = multipleUsers;
    }

    public List<EmployeeAdvanceUsage> getEmployeeAdvanceUsageList() {
        return this.employeeAdvanceUsageList;
    }

    public void setEmployeeAdvanceUsageList(List<EmployeeAdvanceUsage> employeeAdvanceUsageList) {
        this.employeeAdvanceUsageList = employeeAdvanceUsageList;
    }

    public void addEmployeeAdvanceUsageListItem(EmployeeAdvanceUsage item) {
        if (this.getEmployeeAdvanceUsageList() == null) {
            this.setEmployeeAdvanceUsageList(new ArrayList<EmployeeAdvanceUsage>());
        }
        this.getEmployeeAdvanceUsageList().add(item);
        item.setExpense(this);
    }

    public void removeEmployeeAdvanceUsageListItem(EmployeeAdvanceUsage item) {
        if (this.getEmployeeAdvanceUsageList() == null) {
            return;
        }
        this.getEmployeeAdvanceUsageList().remove((Object)item);
        item.setExpense(null);
    }

    public void clearEmployeeAdvanceUsageList() {
        if (this.getEmployeeAdvanceUsageList() != null) {
            for (EmployeeAdvanceUsage item : this.getEmployeeAdvanceUsageList()) {
                item.setExpense(null);
            }
            this.getEmployeeAdvanceUsageList().clear();
        }
    }

    public BigDecimal getAdvanceAmount() {
        return this.advanceAmount == null ? BigDecimal.ZERO : this.advanceAmount;
    }

    public void setAdvanceAmount(BigDecimal advanceAmount) {
        this.advanceAmount = advanceAmount;
    }

    public BigDecimal getWithdrawnCash() {
        return this.withdrawnCash == null ? BigDecimal.ZERO : this.withdrawnCash;
    }

    public void setWithdrawnCash(BigDecimal withdrawnCash) {
        this.withdrawnCash = withdrawnCash;
    }

    public BigDecimal getPersonalExpenseAmount() {
        return this.personalExpenseAmount == null ? BigDecimal.ZERO : this.personalExpenseAmount;
    }

    public void setPersonalExpenseAmount(BigDecimal personalExpenseAmount) {
        this.personalExpenseAmount = personalExpenseAmount;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(LocalDate paymentDate) {
        this.paymentDate = paymentDate;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public BankOrder getBankOrder() {
        return this.bankOrder;
    }

    public void setBankOrder(BankOrder bankOrder) {
        this.bankOrder = bankOrder;
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount == null ? BigDecimal.ZERO : this.paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public Integer getPaymentStatusSelect() {
        return this.paymentStatusSelect == null ? 0 : this.paymentStatusSelect;
    }

    public void setPaymentStatusSelect(Integer paymentStatusSelect) {
        this.paymentStatusSelect = paymentStatusSelect;
    }

    public Move getPaymentMove() {
        return this.paymentMove;
    }

    public void setPaymentMove(Move paymentMove) {
        this.paymentMove = paymentMove;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.getUser() != null) {
            fullName = this.getUser().getFullName();
        }
        if (this.getCreatedOn() != null) {
            fullName = fullName.concat(" ").concat(this.getCreatedOn().format(DateTimeFormatter.ofPattern("yyyyMMdd HH:mm")));
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Expense)) {
            return false;
        }
        Expense other = (Expense)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("expenseSeq", (Object)this.getExpenseSeq()).add("sentDate", (Object)this.getSentDate()).add("statusSelect", (Object)this.getStatusSelect()).add("exTaxTotal", (Object)this.getExTaxTotal()).add("taxTotal", (Object)this.getTaxTotal()).add("inTaxTotal", (Object)this.getInTaxTotal()).add("moveDate", (Object)this.getMoveDate()).add("validationDate", (Object)this.getValidationDate()).add("refusalDate", (Object)this.getRefusalDate()).add("ventilated", (Object)this.getVentilated()).add("companyCbSelect", (Object)this.getCompanyCbSelect()).omitNullValues().toString();
    }
}

