/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.KilometricAllowParam;
import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="HR_EXPENSE_LINE", indexes={@Index(columnList="user_id"), @Index(columnList="project"), @Index(columnList="expense_product"), @Index(columnList="expense"), @Index(columnList="general_expense"), @Index(columnList="kilometric_expense"), @Index(columnList="analytic_distribution_template"), @Index(columnList="justification_meta_file"), @Index(columnList="kilometric_allow_param"), @Index(columnList="fullName")})
public class ExpenseLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EXPENSE_LINE_SEQ")
    @SequenceGenerator(name="HR_EXPENSE_LINE_SEQ", sequenceName="HR_EXPENSE_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User")
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Expense Type")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product expenseProduct;
    @Widget(title="Expense date")
    @NotNull
    private LocalDate expenseDate;
    @Widget(title="Untaxed amount", readonly=true)
    private BigDecimal untaxedAmount = BigDecimal.ZERO;
    @Widget(title="Total tax")
    private BigDecimal totalTax = BigDecimal.ZERO;
    @Widget(title="Total amount with tax")
    @NotNull
    private BigDecimal totalAmount = BigDecimal.ZERO;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    private Boolean toInvoice = Boolean.FALSE;
    @Widget(readonly=true)
    private Boolean invoiced = Boolean.FALSE;
    @Widget(title="Expense")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Expense expense;
    @Widget(title="General Expense")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Expense generalExpense;
    @Widget(title="Kilometric Allowance")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Expense kilometricExpense;
    @Widget(title="Analytic distribution lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="expenseLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AnalyticMoveLine> analyticMoveLineList;
    @Widget(title="Analytic distribution template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @Widget(title="Justification")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile justificationMetaFile;
    @Widget(title="K.A.P.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private KilometricAllowParam kilometricAllowParam;
    @Widget(title="Type", selection="hr.kilometric.allowance.type.select")
    private Integer kilometricTypeSelect = 0;
    @Widget(title="Distance travelled")
    @DecimalMin(value="0")
    private BigDecimal distance = BigDecimal.ZERO;
    @Widget(title="Starting city")
    private String fromCity;
    @Widget(title="Arriving city")
    private String toCity;
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Product getExpenseProduct() {
        return this.expenseProduct;
    }

    public void setExpenseProduct(Product expenseProduct) {
        this.expenseProduct = expenseProduct;
    }

    public LocalDate getExpenseDate() {
        return this.expenseDate;
    }

    public void setExpenseDate(LocalDate expenseDate) {
        this.expenseDate = expenseDate;
    }

    public BigDecimal getUntaxedAmount() {
        return this.untaxedAmount == null ? BigDecimal.ZERO : this.untaxedAmount;
    }

    public void setUntaxedAmount(BigDecimal untaxedAmount) {
        this.untaxedAmount = untaxedAmount;
    }

    public BigDecimal getTotalTax() {
        return this.totalTax == null ? BigDecimal.ZERO : this.totalTax;
    }

    public void setTotalTax(BigDecimal totalTax) {
        this.totalTax = totalTax;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount == null ? BigDecimal.ZERO : this.totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Boolean getToInvoice() {
        return this.toInvoice == null ? Boolean.FALSE : this.toInvoice;
    }

    public void setToInvoice(Boolean toInvoice) {
        this.toInvoice = toInvoice;
    }

    public Boolean getInvoiced() {
        return this.invoiced == null ? Boolean.FALSE : this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public Expense getExpense() {
        return this.expense;
    }

    public void setExpense(Expense expense) {
        this.expense = expense;
    }

    public Expense getGeneralExpense() {
        return this.generalExpense;
    }

    public void setGeneralExpense(Expense generalExpense) {
        this.generalExpense = generalExpense;
    }

    public Expense getKilometricExpense() {
        return this.kilometricExpense;
    }

    public void setKilometricExpense(Expense kilometricExpense) {
        this.kilometricExpense = kilometricExpense;
    }

    public List<AnalyticMoveLine> getAnalyticMoveLineList() {
        return this.analyticMoveLineList;
    }

    public void setAnalyticMoveLineList(List<AnalyticMoveLine> analyticMoveLineList) {
        this.analyticMoveLineList = analyticMoveLineList;
    }

    public void addAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            this.setAnalyticMoveLineList(new ArrayList<AnalyticMoveLine>());
        }
        this.getAnalyticMoveLineList().add(item);
        item.setExpenseLine(this);
    }

    public void removeAnalyticMoveLineListItem(AnalyticMoveLine item) {
        if (this.getAnalyticMoveLineList() == null) {
            return;
        }
        this.getAnalyticMoveLineList().remove((Object)item);
    }

    public void clearAnalyticMoveLineList() {
        if (this.getAnalyticMoveLineList() != null) {
            this.getAnalyticMoveLineList().clear();
        }
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public MetaFile getJustificationMetaFile() {
        return this.justificationMetaFile;
    }

    public void setJustificationMetaFile(MetaFile justificationMetaFile) {
        this.justificationMetaFile = justificationMetaFile;
    }

    public KilometricAllowParam getKilometricAllowParam() {
        return this.kilometricAllowParam;
    }

    public void setKilometricAllowParam(KilometricAllowParam kilometricAllowParam) {
        this.kilometricAllowParam = kilometricAllowParam;
    }

    public Integer getKilometricTypeSelect() {
        return this.kilometricTypeSelect == null ? 0 : this.kilometricTypeSelect;
    }

    public void setKilometricTypeSelect(Integer kilometricTypeSelect) {
        this.kilometricTypeSelect = kilometricTypeSelect;
    }

    public BigDecimal getDistance() {
        return this.distance == null ? BigDecimal.ZERO : this.distance;
    }

    public void setDistance(BigDecimal distance) {
        this.distance = distance;
    }

    public String getFromCity() {
        return this.fromCity;
    }

    public void setFromCity(String fromCity) {
        this.fromCity = fromCity;
    }

    public String getToCity() {
        return this.toCity;
    }

    public void setToCity(String toCity) {
        this.toCity = toCity;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.expense != null && this.expense.getFullName() != null) {
            fullName = fullName + this.expense.getFullName();
        }
        fullName = !fullName.isEmpty() ? fullName + "-" + this.id : this.id.toString();
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExpenseLine)) {
            return false;
        }
        ExpenseLine other = (ExpenseLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("expenseDate", (Object)this.getExpenseDate()).add("untaxedAmount", (Object)this.getUntaxedAmount()).add("totalTax", (Object)this.getTotalTax()).add("totalAmount", (Object)this.getTotalAmount()).add("toInvoice", (Object)this.getToInvoice()).add("invoiced", (Object)this.getInvoiced()).add("kilometricTypeSelect", (Object)this.getKilometricTypeSelect()).add("distance", (Object)this.getDistance()).add("fromCity", (Object)this.getFromCity()).add("toCity", (Object)this.getToCity()).omitNullValues().toString();
    }
}

