/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.hr.db.ExtraHoursLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="HR_EXTRA_HOURS", indexes={@Index(columnList="user_id"), @Index(columnList="company"), @Index(columnList="validated_by"), @Index(columnList="refused_by"), @Index(columnList="fullName")})
public class ExtraHours
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EXTRA_HOURS_SEQ")
    @SequenceGenerator(name="HR_EXTRA_HOURS_SEQ", sequenceName="HR_EXTRA_HOURS_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User")
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Status", readonly=true, selection="hrs.leave.request.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Sent Date", readonly=true)
    private LocalDate sentDate;
    @Widget(title="Validated by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedBy;
    @Widget(title="Refused By", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User refusedBy;
    @Widget(title="Validation Date", readonly=true)
    private LocalDate validationDate;
    @Widget(title="Refusal Date", readonly=true)
    private LocalDate refusalDate;
    @Widget(title="Ground For Refusal")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String groundForRefusal;
    @Widget(title="Total (h)", readonly=true)
    private BigDecimal totalQty = BigDecimal.ZERO;
    @Widget(title="Extra Hours")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="extraHours", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ExtraHoursLine> extraHoursLineList;
    @Widget(readonly=true)
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(LocalDate sentDate) {
        this.sentDate = sentDate;
    }

    public User getValidatedBy() {
        return this.validatedBy;
    }

    public void setValidatedBy(User validatedBy) {
        this.validatedBy = validatedBy;
    }

    public User getRefusedBy() {
        return this.refusedBy;
    }

    public void setRefusedBy(User refusedBy) {
        this.refusedBy = refusedBy;
    }

    public LocalDate getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(LocalDate validationDate) {
        this.validationDate = validationDate;
    }

    public LocalDate getRefusalDate() {
        return this.refusalDate;
    }

    public void setRefusalDate(LocalDate refusalDate) {
        this.refusalDate = refusalDate;
    }

    public String getGroundForRefusal() {
        return this.groundForRefusal;
    }

    public void setGroundForRefusal(String groundForRefusal) {
        this.groundForRefusal = groundForRefusal;
    }

    public BigDecimal getTotalQty() {
        return this.totalQty == null ? BigDecimal.ZERO : this.totalQty;
    }

    public void setTotalQty(BigDecimal totalQty) {
        this.totalQty = totalQty;
    }

    public List<ExtraHoursLine> getExtraHoursLineList() {
        return this.extraHoursLineList;
    }

    public void setExtraHoursLineList(List<ExtraHoursLine> extraHoursLineList) {
        this.extraHoursLineList = extraHoursLineList;
    }

    public void addExtraHoursLineListItem(ExtraHoursLine item) {
        if (this.getExtraHoursLineList() == null) {
            this.setExtraHoursLineList(new ArrayList<ExtraHoursLine>());
        }
        this.getExtraHoursLineList().add(item);
        item.setExtraHours(this);
    }

    public void removeExtraHoursLineListItem(ExtraHoursLine item) {
        if (this.getExtraHoursLineList() == null) {
            return;
        }
        this.getExtraHoursLineList().remove((Object)item);
    }

    public void clearExtraHoursLineList() {
        if (this.getExtraHoursLineList() != null) {
            this.getExtraHoursLineList().clear();
        }
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        String fullName = "";
        if (this.getUser() != null) {
            fullName = this.getUser().getFullName();
        }
        if (this.getCreatedOn() != null) {
            fullName = fullName.concat(" ").concat(this.getCreatedOn().format(DateTimeFormatter.ofPattern("yyyyMMdd HH:mm")));
        }
        return fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExtraHours)) {
            return false;
        }
        ExtraHours other = (ExtraHours)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("sentDate", (Object)this.getSentDate()).add("validationDate", (Object)this.getValidationDate()).add("refusalDate", (Object)this.getRefusalDate()).add("totalQty", (Object)this.getTotalQty()).omitNullValues().toString();
    }
}

