/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.ExtraHours;
import com.axelor.apps.hr.db.ExtraHoursType;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.apps.project.db.Project;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_EXTRA_HOURS_LINE", indexes={@Index(columnList="payroll_preparation"), @Index(columnList="extra_hours"), @Index(columnList="user_id"), @Index(columnList="extra_hours_type"), @Index(columnList="project")})
public class ExtraHoursLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EXTRA_HOURS_LINE_SEQ")
    @SequenceGenerator(name="HR_EXTRA_HOURS_LINE_SEQ", sequenceName="HR_EXTRA_HOURS_LINE_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PayrollPreparation payrollPreparation;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ExtraHours extraHours;
    @Widget(title="User")
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="From")
    @NotNull
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Hours")
    private BigDecimal qty = BigDecimal.ZERO;
    @Widget(title="Extra hours type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ExtraHoursType extraHoursType;
    @Widget(title="Project")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PayrollPreparation getPayrollPreparation() {
        return this.payrollPreparation;
    }

    public void setPayrollPreparation(PayrollPreparation payrollPreparation) {
        this.payrollPreparation = payrollPreparation;
    }

    public ExtraHours getExtraHours() {
        return this.extraHours;
    }

    public void setExtraHours(ExtraHours extraHours) {
        this.extraHours = extraHours;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public BigDecimal getQty() {
        return this.qty == null ? BigDecimal.ZERO : this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public ExtraHoursType getExtraHoursType() {
        return this.extraHoursType;
    }

    public void setExtraHoursType(ExtraHoursType extraHoursType) {
        this.extraHoursType = extraHoursType;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExtraHoursLine)) {
            return false;
        }
        ExtraHoursLine other = (ExtraHoursLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("date", (Object)this.getDate()).add("qty", (Object)this.getQty()).omitNullValues().toString();
    }
}

