/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_EXTRA_HOURS_TYPE", indexes={@Index(columnList="name")})
public class ExtraHoursType
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_EXTRA_HOURS_TYPE_SEQ")
    @SequenceGenerator(name="HR_EXTRA_HOURS_TYPE_SEQ", sequenceName="HR_EXTRA_HOURS_TYPE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Extra hours type")
    private String name;
    @Widget(title="Increase %")
    @DecimalMin(value="0")
    @DecimalMax(value="100")
    private BigDecimal increase = BigDecimal.ZERO;
    @Widget(title="Export for payroll preparation")
    private Boolean payrollPreprationExport = Boolean.FALSE;
    @Widget(title="Export code")
    private String exportCode;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ExtraHoursType() {
    }

    public ExtraHoursType(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getIncrease() {
        return this.increase == null ? BigDecimal.ZERO : this.increase;
    }

    public void setIncrease(BigDecimal increase) {
        this.increase = increase;
    }

    public Boolean getPayrollPreprationExport() {
        return this.payrollPreprationExport == null ? Boolean.FALSE : this.payrollPreprationExport;
    }

    public void setPayrollPreprationExport(Boolean payrollPreprationExport) {
        this.payrollPreprationExport = payrollPreprationExport;
    }

    public String getExportCode() {
        return this.exportCode;
    }

    public void setExportCode(String exportCode) {
        this.exportCode = exportCode;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExtraHoursType)) {
            return false;
        }
        ExtraHoursType other = (ExtraHoursType)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("increase", (Object)this.getIncrease()).add("payrollPreprationExport", (Object)this.getPayrollPreprationExport()).add("exportCode", (Object)this.getExportCode()).omitNullValues().toString();
    }
}

