/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.KilometricAllowanceRate;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_KILOMETRIC_ALLOWANCE_RULE", indexes={@Index(columnList="hr_config"), @Index(columnList="kilometric_allowance_rate")})
public class KilometricAllowanceRule
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_KILOMETRIC_ALLOWANCE_RULE_SEQ")
    @SequenceGenerator(name="HR_KILOMETRIC_ALLOWANCE_RULE_SEQ", sequenceName="HR_KILOMETRIC_ALLOWANCE_RULE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="HrConfig")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private HRConfig hrConfig;
    @Widget(title="Rate")
    @NotNull
    @Digits(integer=17, fraction=3)
    private BigDecimal rate = BigDecimal.ZERO;
    @Widget(title="Minimum Condition")
    private BigDecimal minimumCondition = BigDecimal.ZERO;
    @Widget(title="Maximum Condition")
    private BigDecimal maximumCondition = BigDecimal.ZERO;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private KilometricAllowanceRate kilometricAllowanceRate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public HRConfig getHrConfig() {
        return this.hrConfig;
    }

    public void setHrConfig(HRConfig hrConfig) {
        this.hrConfig = hrConfig;
    }

    public BigDecimal getRate() {
        return this.rate == null ? BigDecimal.ZERO : this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public BigDecimal getMinimumCondition() {
        return this.minimumCondition == null ? BigDecimal.ZERO : this.minimumCondition;
    }

    public void setMinimumCondition(BigDecimal minimumCondition) {
        this.minimumCondition = minimumCondition;
    }

    public BigDecimal getMaximumCondition() {
        return this.maximumCondition == null ? BigDecimal.ZERO : this.maximumCondition;
    }

    public void setMaximumCondition(BigDecimal maximumCondition) {
        this.maximumCondition = maximumCondition;
    }

    public KilometricAllowanceRate getKilometricAllowanceRate() {
        return this.kilometricAllowanceRate;
    }

    public void setKilometricAllowanceRate(KilometricAllowanceRate kilometricAllowanceRate) {
        this.kilometricAllowanceRate = kilometricAllowanceRate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KilometricAllowanceRule)) {
            return false;
        }
        KilometricAllowanceRule other = (KilometricAllowanceRule)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("rate", (Object)this.getRate()).add("minimumCondition", (Object)this.getMinimumCondition()).add("maximumCondition", (Object)this.getMaximumCondition()).omitNullValues().toString();
    }
}

