/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Year;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HR_KILOMETRIC_LOG", uniqueConstraints={@UniqueConstraint(columnNames={"employee", "year"})}, indexes={@Index(columnList="employee"), @Index(columnList="year")})
public class KilometricLog
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_KILOMETRIC_LOG_SEQ")
    @SequenceGenerator(name="HR_KILOMETRIC_LOG_SEQ", sequenceName="HR_KILOMETRIC_LOG_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Distance travelled")
    private BigDecimal distanceTravelled = BigDecimal.ZERO;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Year")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Year year;
    @Widget(title="Kilometric allowance list")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<ExpenseLine> expenseLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public BigDecimal getDistanceTravelled() {
        return this.distanceTravelled == null ? BigDecimal.ZERO : this.distanceTravelled;
    }

    public void setDistanceTravelled(BigDecimal distanceTravelled) {
        this.distanceTravelled = distanceTravelled;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Year getYear() {
        return this.year;
    }

    public void setYear(Year year) {
        this.year = year;
    }

    public List<ExpenseLine> getExpenseLineList() {
        return this.expenseLineList;
    }

    public void setExpenseLineList(List<ExpenseLine> expenseLineList) {
        this.expenseLineList = expenseLineList;
    }

    public void addExpenseLineListItem(ExpenseLine item) {
        if (this.getExpenseLineList() == null) {
            this.setExpenseLineList(new ArrayList<ExpenseLine>());
        }
        this.getExpenseLineList().add(item);
    }

    public void removeExpenseLineListItem(ExpenseLine item) {
        if (this.getExpenseLineList() == null) {
            return;
        }
        this.getExpenseLineList().remove((Object)item);
    }

    public void clearExpenseLineList() {
        if (this.getExpenseLineList() != null) {
            this.getExpenseLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KilometricLog)) {
            return false;
        }
        KilometricLog other = (KilometricLog)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("distanceTravelled", (Object)this.getDistanceTravelled()).omitNullValues().toString();
    }
}

