/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.LeaveManagement;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_LEAVE_LINE", indexes={@Index(columnList="employee"), @Index(columnList="leave_reason"), @Index(columnList="name")})
public class LeaveLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_LEAVE_LINE_SEQ")
    @SequenceGenerator(name="HR_LEAVE_LINE_SEQ", sequenceName="HR_LEAVE_LINE_SEQ", allocationSize=1)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Type")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LeaveReason leaveReason;
    @Widget(title="Remaining")
    @Digits(integer=16, fraction=4)
    private BigDecimal quantity = BigDecimal.ZERO;
    @Widget(title="Waiting for validation")
    @Digits(integer=16, fraction=4)
    private BigDecimal daysToValidate = BigDecimal.ZERO;
    @Widget(title="Days validated")
    @Digits(integer=16, fraction=4)
    private BigDecimal daysValidated = BigDecimal.ZERO;
    @Widget(title="Acquired")
    @Digits(integer=16, fraction=4)
    private BigDecimal totalQuantity = BigDecimal.ZERO;
    @Widget(title="Leaves Management")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="leaveLine", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LeaveManagement> leaveManagementList;
    @NameColumn
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public LeaveLine() {
    }

    public LeaveLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public LeaveReason getLeaveReason() {
        return this.leaveReason;
    }

    public void setLeaveReason(LeaveReason leaveReason) {
        this.leaveReason = leaveReason;
    }

    public BigDecimal getQuantity() {
        return this.quantity == null ? BigDecimal.ZERO : this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getDaysToValidate() {
        return this.daysToValidate == null ? BigDecimal.ZERO : this.daysToValidate;
    }

    public void setDaysToValidate(BigDecimal daysToValidate) {
        this.daysToValidate = daysToValidate;
    }

    public BigDecimal getDaysValidated() {
        return this.daysValidated == null ? BigDecimal.ZERO : this.daysValidated;
    }

    public void setDaysValidated(BigDecimal daysValidated) {
        this.daysValidated = daysValidated;
    }

    public BigDecimal getTotalQuantity() {
        return this.totalQuantity == null ? BigDecimal.ZERO : this.totalQuantity;
    }

    public void setTotalQuantity(BigDecimal totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public List<LeaveManagement> getLeaveManagementList() {
        return this.leaveManagementList;
    }

    public void setLeaveManagementList(List<LeaveManagement> leaveManagementList) {
        this.leaveManagementList = leaveManagementList;
    }

    public void addLeaveManagementListItem(LeaveManagement item) {
        if (this.getLeaveManagementList() == null) {
            this.setLeaveManagementList(new ArrayList<LeaveManagement>());
        }
        this.getLeaveManagementList().add(item);
        item.setLeaveLine(this);
    }

    public void removeLeaveManagementListItem(LeaveManagement item) {
        if (this.getLeaveManagementList() == null) {
            return;
        }
        this.getLeaveManagementList().remove((Object)item);
    }

    public void clearLeaveManagementList() {
        if (this.getLeaveManagementList() != null) {
            this.getLeaveManagementList().clear();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LeaveLine)) {
            return false;
        }
        LeaveLine other = (LeaveLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("quantity", (Object)this.getQuantity()).add("daysToValidate", (Object)this.getDaysToValidate()).add("daysValidated", (Object)this.getDaysValidated()).add("totalQuantity", (Object)this.getTotalQuantity()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

