/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_LEAVE_MANAGEMENT", indexes={@Index(columnList="leave_line"), @Index(columnList="user_id")})
public class LeaveManagement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_LEAVE_MANAGEMENT_SEQ")
    @SequenceGenerator(name="HR_LEAVE_MANAGEMENT_SEQ", sequenceName="HR_LEAVE_MANAGEMENT_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LeaveLine leaveLine;
    @Widget(title="Value")
    @Digits(integer=4, fraction=4)
    private BigDecimal value = BigDecimal.ZERO;
    @Digits(integer=4, fraction=4)
    private BigDecimal oldValue = BigDecimal.ZERO;
    @Widget(title="Date")
    @NotNull
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="From")
    private LocalDate fromDate;
    @Widget(title="To (included)")
    private LocalDate toDate;
    @Widget(title="Comments", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="User")
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    private Boolean counted = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LeaveLine getLeaveLine() {
        return this.leaveLine;
    }

    public void setLeaveLine(LeaveLine leaveLine) {
        this.leaveLine = leaveLine;
    }

    public BigDecimal getValue() {
        return this.value == null ? BigDecimal.ZERO : this.value;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public BigDecimal getOldValue() {
        return this.oldValue == null ? BigDecimal.ZERO : this.oldValue;
    }

    public void setOldValue(BigDecimal oldValue) {
        this.oldValue = oldValue;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Boolean getCounted() {
        return this.counted == null ? Boolean.FALSE : this.counted;
    }

    public void setCounted(Boolean counted) {
        this.counted = counted;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LeaveManagement)) {
            return false;
        }
        LeaveManagement other = (LeaveManagement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("value", (Object)this.getValue()).add("oldValue", (Object)this.getOldValue()).add("date", (Object)this.getDate()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("counted", (Object)this.getCounted()).omitNullValues().toString();
    }
}

