/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.ICalendarEvent;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="HR_LEAVE_REQUEST", indexes={@Index(columnList="user_id"), @Index(columnList="company"), @Index(columnList="validated_by"), @Index(columnList="refused_by"), @Index(columnList="icalendar_event"), @Index(columnList="leave_line"), @Index(columnList="fullName")})
public class LeaveRequest
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_LEAVE_REQUEST_SEQ")
    @SequenceGenerator(name="HR_LEAVE_REQUEST_SEQ", sequenceName="HR_LEAVE_REQUEST_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="User")
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Status", readonly=true, selection="hrs.leave.request.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Request date", readonly=true)
    private LocalDate requestDate;
    @Widget(title="From")
    @NotNull
    private LocalDateTime fromDateT;
    @Widget(title="Start On", selection="hr.start.on.select")
    @NotNull
    private Integer startOnSelect = 1;
    @Widget(title="To (included)")
    private LocalDateTime toDateT;
    @Widget(title="End On", selection="hr.start.on.select")
    @NotNull
    private Integer endOnSelect = 2;
    @Widget(title="Duration")
    @Digits(integer=19, fraction=1)
    private BigDecimal duration = BigDecimal.ZERO;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Inject/Consume", selection="hrs.leave.reason.inject.consume.select")
    private Integer injectConsumeSelect = 1;
    @Widget(title="Validated by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedBy;
    @Widget(title="Refused By", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User refusedBy;
    @Widget(title="Validation Date", readonly=true)
    private LocalDate validationDate;
    @Widget(title="Refusal Date", readonly=true)
    private LocalDate refusalDate;
    @Widget(title="Ground For Refusal")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String groundForRefusal;
    @Widget(title="Event")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ICalendarEvent icalendarEvent;
    @Widget(title="Leave line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LeaveLine leaveLine;
    @Widget(title="Available quantity (before validation)")
    @Digits(integer=4, fraction=4)
    private BigDecimal quantityBeforeValidation = BigDecimal.ZERO;
    @Widget(title="Leave to justify")
    private Boolean toJustifyLeaveReason = Boolean.FALSE;
    @Widget(readonly=true)
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public LocalDate getRequestDate() {
        return this.requestDate;
    }

    public void setRequestDate(LocalDate requestDate) {
        this.requestDate = requestDate;
    }

    public LocalDateTime getFromDateT() {
        return this.fromDateT;
    }

    public void setFromDateT(LocalDateTime fromDateT) {
        this.fromDateT = fromDateT;
    }

    public Integer getStartOnSelect() {
        return this.startOnSelect == null ? 0 : this.startOnSelect;
    }

    public void setStartOnSelect(Integer startOnSelect) {
        this.startOnSelect = startOnSelect;
    }

    public LocalDateTime getToDateT() {
        return this.toDateT;
    }

    public void setToDateT(LocalDateTime toDateT) {
        this.toDateT = toDateT;
    }

    public Integer getEndOnSelect() {
        return this.endOnSelect == null ? 0 : this.endOnSelect;
    }

    public void setEndOnSelect(Integer endOnSelect) {
        this.endOnSelect = endOnSelect;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? BigDecimal.ZERO : this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Integer getInjectConsumeSelect() {
        return this.injectConsumeSelect == null ? 0 : this.injectConsumeSelect;
    }

    public void setInjectConsumeSelect(Integer injectConsumeSelect) {
        this.injectConsumeSelect = injectConsumeSelect;
    }

    public User getValidatedBy() {
        return this.validatedBy;
    }

    public void setValidatedBy(User validatedBy) {
        this.validatedBy = validatedBy;
    }

    public User getRefusedBy() {
        return this.refusedBy;
    }

    public void setRefusedBy(User refusedBy) {
        this.refusedBy = refusedBy;
    }

    public LocalDate getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(LocalDate validationDate) {
        this.validationDate = validationDate;
    }

    public LocalDate getRefusalDate() {
        return this.refusalDate;
    }

    public void setRefusalDate(LocalDate refusalDate) {
        this.refusalDate = refusalDate;
    }

    public String getGroundForRefusal() {
        return this.groundForRefusal;
    }

    public void setGroundForRefusal(String groundForRefusal) {
        this.groundForRefusal = groundForRefusal;
    }

    public ICalendarEvent getIcalendarEvent() {
        return this.icalendarEvent;
    }

    public void setIcalendarEvent(ICalendarEvent icalendarEvent) {
        this.icalendarEvent = icalendarEvent;
    }

    public LeaveLine getLeaveLine() {
        return this.leaveLine;
    }

    public void setLeaveLine(LeaveLine leaveLine) {
        this.leaveLine = leaveLine;
    }

    public BigDecimal getQuantityBeforeValidation() {
        return this.quantityBeforeValidation == null ? BigDecimal.ZERO : this.quantityBeforeValidation;
    }

    public void setQuantityBeforeValidation(BigDecimal quantityBeforeValidation) {
        this.quantityBeforeValidation = quantityBeforeValidation;
    }

    public Boolean getToJustifyLeaveReason() {
        return this.toJustifyLeaveReason == null ? Boolean.FALSE : this.toJustifyLeaveReason;
    }

    public void setToJustifyLeaveReason(Boolean toJustifyLeaveReason) {
        this.toJustifyLeaveReason = toJustifyLeaveReason;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        if (this.getUser() != null && this.getCreatedOn() != null) {
            return this.getUser().getFullName() + " " + this.getCreatedOn().getDayOfMonth() + "/" + this.getCreatedOn().getMonthValue() + "/" + this.getCreatedOn().getYear() + "  " + this.getCreatedOn().getHour() + ":" + this.getCreatedOn().getMinute();
        }
        return " ";
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LeaveRequest)) {
            return false;
        }
        LeaveRequest other = (LeaveRequest)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("requestDate", (Object)this.getRequestDate()).add("fromDateT", (Object)this.getFromDateT()).add("startOnSelect", (Object)this.getStartOnSelect()).add("toDateT", (Object)this.getToDateT()).add("endOnSelect", (Object)this.getEndOnSelect()).add("duration", (Object)this.getDuration()).add("injectConsumeSelect", (Object)this.getInjectConsumeSelect()).add("validationDate", (Object)this.getValidationDate()).add("refusalDate", (Object)this.getRefusalDate()).add("quantityBeforeValidation", (Object)this.getQuantityBeforeValidation()).omitNullValues().toString();
    }
}

