/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.LunchVoucherMgt;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_LUNCH_VOUCHER_MGT_LINE", indexes={@Index(columnList="lunch_voucher_mgt"), @Index(columnList="employee"), @Index(columnList="payroll_preparation")})
public class LunchVoucherMgtLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_LUNCH_VOUCHER_MGT_LINE_SEQ")
    @SequenceGenerator(name="HR_LUNCH_VOUCHER_MGT_LINE_SEQ", sequenceName="HR_LUNCH_VOUCHER_MGT_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Lunch Voucher", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LunchVoucherMgt lunchVoucherMgt;
    @Widget(title="Employee", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Number of canteen entries")
    private Integer canteenEntries = 0;
    @Widget(title="Number of days overseas")
    private Integer daysOverseas = 0;
    @Widget(title="Invitation")
    private Integer invitation = 0;
    @Widget(title="In advance", readonly=true)
    private Integer inAdvanceNbr = 0;
    @Widget(title="Number of lunch vouchers", readonly=true)
    private Integer lunchVoucherNumber = 0;
    @Widget(title="Number of days worked", readonly=true)
    private Integer daysWorkedNbr = 0;
    @Widget(title="Comments")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String comments;
    @Widget(title="Given to Employee")
    private Integer givenToEmployee = 0;
    @Widget(title="Payroll preparation")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PayrollPreparation payrollPreparation;
    @Widget(title="Status", readonly=true, selection="hr.lunch.voucher.line.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Lunch Voucher Format", readonly=true, selection="hr.lunch.voucher.mgt.line.lunch.voucher.format.select")
    private Integer lunchVoucherFormatSelect = 0;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LunchVoucherMgt getLunchVoucherMgt() {
        return this.lunchVoucherMgt;
    }

    public void setLunchVoucherMgt(LunchVoucherMgt lunchVoucherMgt) {
        this.lunchVoucherMgt = lunchVoucherMgt;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Integer getCanteenEntries() {
        return this.canteenEntries == null ? 0 : this.canteenEntries;
    }

    public void setCanteenEntries(Integer canteenEntries) {
        this.canteenEntries = canteenEntries;
    }

    public Integer getDaysOverseas() {
        return this.daysOverseas == null ? 0 : this.daysOverseas;
    }

    public void setDaysOverseas(Integer daysOverseas) {
        this.daysOverseas = daysOverseas;
    }

    public Integer getInvitation() {
        return this.invitation == null ? 0 : this.invitation;
    }

    public void setInvitation(Integer invitation) {
        this.invitation = invitation;
    }

    public Integer getInAdvanceNbr() {
        return this.inAdvanceNbr == null ? 0 : this.inAdvanceNbr;
    }

    public void setInAdvanceNbr(Integer inAdvanceNbr) {
        this.inAdvanceNbr = inAdvanceNbr;
    }

    public Integer getLunchVoucherNumber() {
        return this.lunchVoucherNumber == null ? 0 : this.lunchVoucherNumber;
    }

    public void setLunchVoucherNumber(Integer lunchVoucherNumber) {
        this.lunchVoucherNumber = lunchVoucherNumber;
    }

    public Integer getDaysWorkedNbr() {
        return this.daysWorkedNbr == null ? 0 : this.daysWorkedNbr;
    }

    public void setDaysWorkedNbr(Integer daysWorkedNbr) {
        this.daysWorkedNbr = daysWorkedNbr;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getGivenToEmployee() {
        return this.givenToEmployee == null ? 0 : this.givenToEmployee;
    }

    public void setGivenToEmployee(Integer givenToEmployee) {
        this.givenToEmployee = givenToEmployee;
    }

    public PayrollPreparation getPayrollPreparation() {
        return this.payrollPreparation;
    }

    public void setPayrollPreparation(PayrollPreparation payrollPreparation) {
        this.payrollPreparation = payrollPreparation;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getLunchVoucherFormatSelect() {
        return this.lunchVoucherFormatSelect == null ? 0 : this.lunchVoucherFormatSelect;
    }

    public void setLunchVoucherFormatSelect(Integer lunchVoucherFormatSelect) {
        this.lunchVoucherFormatSelect = lunchVoucherFormatSelect;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LunchVoucherMgtLine)) {
            return false;
        }
        LunchVoucherMgtLine other = (LunchVoucherMgtLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("canteenEntries", (Object)this.getCanteenEntries()).add("daysOverseas", (Object)this.getDaysOverseas()).add("invitation", (Object)this.getInvitation()).add("inAdvanceNbr", (Object)this.getInAdvanceNbr()).add("lunchVoucherNumber", (Object)this.getLunchVoucherNumber()).add("daysWorkedNbr", (Object)this.getDaysWorkedNbr()).add("givenToEmployee", (Object)this.getGivenToEmployee()).add("statusSelect", (Object)this.getStatusSelect()).add("lunchVoucherFormatSelect", (Object)this.getLunchVoucherFormatSelect()).omitNullValues().toString();
    }
}

