/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_PAYROLL_LEAVE", indexes={@Index(columnList="payroll_preparation"), @Index(columnList="leave_reason"), @Index(columnList="leave_request")})
public class PayrollLeave
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_PAYROLL_LEAVE_SEQ")
    @SequenceGenerator(name="HR_PAYROLL_LEAVE_SEQ", sequenceName="HR_PAYROLL_LEAVE_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PayrollPreparation payrollPreparation;
    @Widget(title="From")
    @NotNull
    private LocalDate fromDate;
    @Widget(title="To")
    @NotNull
    private LocalDate toDate;
    @Widget(title="Duration")
    @Digits(integer=4, fraction=1)
    private BigDecimal duration = BigDecimal.ZERO;
    @Widget(title="Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LeaveReason leaveReason;
    @Widget(title="Leave request")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private LeaveRequest leaveRequest;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PayrollPreparation getPayrollPreparation() {
        return this.payrollPreparation;
    }

    public void setPayrollPreparation(PayrollPreparation payrollPreparation) {
        this.payrollPreparation = payrollPreparation;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? BigDecimal.ZERO : this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public LeaveReason getLeaveReason() {
        return this.leaveReason;
    }

    public void setLeaveReason(LeaveReason leaveReason) {
        this.leaveReason = leaveReason;
    }

    public LeaveRequest getLeaveRequest() {
        return this.leaveRequest;
    }

    public void setLeaveRequest(LeaveRequest leaveRequest) {
        this.leaveRequest = leaveRequest;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PayrollLeave)) {
            return false;
        }
        PayrollLeave other = (PayrollLeave)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("duration", (Object)this.getDuration()).omitNullValues().toString();
    }
}

