/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Cacheable
@DynamicInsert
@DynamicUpdate
@Table(name="HR_TIMESHEET", indexes={@Index(columnList="user_id"), @Index(columnList="company"), @Index(columnList="validated_by"), @Index(columnList="refused_by"), @Index(columnList="fullName")})
@Track(fields={@TrackField(name="statusSelect")})
public class Timesheet
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_TIMESHEET_SEQ")
    @SequenceGenerator(name="HR_TIMESHEET_SEQ", sequenceName="HR_TIMESHEET_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Sent Date", readonly=true)
    private LocalDate sentDate;
    @Widget(title="Status", readonly=true, selection="hrs.timesheet.status.select")
    private Integer statusSelect = 1;
    @Widget(title="User", readonly=true)
    @NotNull
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="Timesheet Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="timesheet", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TimesheetLine> timesheetLineList;
    private LocalDate fromDate;
    private LocalDate toDate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Validated by", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedBy;
    @Widget(title="Refused By", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User refusedBy;
    @Widget(title="Validation Date", readonly=true)
    private LocalDate validationDate;
    @Widget(title="Refusal Date", readonly=true)
    private LocalDate refusalDate;
    @Widget(title="Ground For Refusal")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String groundForRefusal;
    @Widget(title="Total on period (hours)")
    private BigDecimal periodTotal = BigDecimal.ZERO;
    @Widget(title="Show editor")
    private Boolean showEditor = Boolean.FALSE;
    @Widget(title="Time logging preference", selection="hr.time.logging.preference.select")
    private String timeLoggingPreferenceSelect;
    @Widget(readonly=true)
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String fullName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(LocalDate sentDate) {
        this.sentDate = sentDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public List<TimesheetLine> getTimesheetLineList() {
        return this.timesheetLineList;
    }

    public void setTimesheetLineList(List<TimesheetLine> timesheetLineList) {
        this.timesheetLineList = timesheetLineList;
    }

    public void addTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            this.setTimesheetLineList(new ArrayList<TimesheetLine>());
        }
        this.getTimesheetLineList().add(item);
        item.setTimesheet(this);
    }

    public void removeTimesheetLineListItem(TimesheetLine item) {
        if (this.getTimesheetLineList() == null) {
            return;
        }
        this.getTimesheetLineList().remove((Object)item);
    }

    public void clearTimesheetLineList() {
        if (this.getTimesheetLineList() != null) {
            this.getTimesheetLineList().clear();
        }
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public User getValidatedBy() {
        return this.validatedBy;
    }

    public void setValidatedBy(User validatedBy) {
        this.validatedBy = validatedBy;
    }

    public User getRefusedBy() {
        return this.refusedBy;
    }

    public void setRefusedBy(User refusedBy) {
        this.refusedBy = refusedBy;
    }

    public LocalDate getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(LocalDate validationDate) {
        this.validationDate = validationDate;
    }

    public LocalDate getRefusalDate() {
        return this.refusalDate;
    }

    public void setRefusalDate(LocalDate refusalDate) {
        this.refusalDate = refusalDate;
    }

    public String getGroundForRefusal() {
        return this.groundForRefusal;
    }

    public void setGroundForRefusal(String groundForRefusal) {
        this.groundForRefusal = groundForRefusal;
    }

    public BigDecimal getPeriodTotal() {
        return this.periodTotal == null ? BigDecimal.ZERO : this.periodTotal;
    }

    public void setPeriodTotal(BigDecimal periodTotal) {
        this.periodTotal = periodTotal;
    }

    public Boolean getShowEditor() {
        return this.showEditor == null ? Boolean.FALSE : this.showEditor;
    }

    public void setShowEditor(Boolean showEditor) {
        this.showEditor = showEditor;
    }

    public String getTimeLoggingPreferenceSelect() {
        return this.timeLoggingPreferenceSelect;
    }

    public void setTimeLoggingPreferenceSelect(String timeLoggingPreferenceSelect) {
        this.timeLoggingPreferenceSelect = timeLoggingPreferenceSelect;
    }

    public String getFullName() {
        try {
            this.fullName = this.computeFullName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getFullName()", (Throwable)e);
        }
        return this.fullName;
    }

    protected String computeFullName() {
        if (this.getUser() != null && this.getCreatedOn() != null) {
            return this.getUser().getFullName() + " " + this.getCreatedOn().getDayOfMonth() + "/" + this.getCreatedOn().getMonthValue() + "/" + this.getCreatedOn().getYear() + "  " + this.getCreatedOn().getHour() + ":" + this.getCreatedOn().getMinute();
        }
        if (this.getUser() != null) {
            return this.getUser().getFullName() + " N\u00b0" + this.getId();
        }
        return "N\u00b0" + this.getId();
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Timesheet)) {
            return false;
        }
        Timesheet other = (Timesheet)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("sentDate", (Object)this.getSentDate()).add("statusSelect", (Object)this.getStatusSelect()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("validationDate", (Object)this.getValidationDate()).add("refusalDate", (Object)this.getRefusalDate()).add("periodTotal", (Object)this.getPeriodTotal()).add("showEditor", (Object)this.getShowEditor()).add("timeLoggingPreferenceSelect", (Object)this.getTimeLoggingPreferenceSelect()).omitNullValues().toString();
    }
}

