/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db;

import com.axelor.apps.hr.db.TimesheetReminder;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="HR_TIMESHEET_REMINDER_LINE", indexes={@Index(columnList="timesheet_reminder")})
public class TimesheetReminderLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="HR_TIMESHEET_REMINDER_LINE_SEQ")
    @SequenceGenerator(name="HR_TIMESHEET_REMINDER_LINE_SEQ", sequenceName="HR_TIMESHEET_REMINDER_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Timesheet reminder")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TimesheetReminder timesheetReminder;
    @Widget(title="From date")
    private LocalDate fromDate;
    @Widget(title="To date")
    private LocalDate toDate;
    @Widget(title="Missing hours")
    private BigDecimal missingHours = BigDecimal.ZERO;
    @Widget(title="Extra hours")
    private BigDecimal extraHours = BigDecimal.ZERO;
    @Widget(title="Total required hours")
    private BigDecimal requiredHours = BigDecimal.ZERO;
    @Widget(title="Work hours")
    private BigDecimal workHour = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TimesheetReminder getTimesheetReminder() {
        return this.timesheetReminder;
    }

    public void setTimesheetReminder(TimesheetReminder timesheetReminder) {
        this.timesheetReminder = timesheetReminder;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public BigDecimal getMissingHours() {
        return this.missingHours == null ? BigDecimal.ZERO : this.missingHours;
    }

    public void setMissingHours(BigDecimal missingHours) {
        this.missingHours = missingHours;
    }

    public BigDecimal getExtraHours() {
        return this.extraHours == null ? BigDecimal.ZERO : this.extraHours;
    }

    public void setExtraHours(BigDecimal extraHours) {
        this.extraHours = extraHours;
    }

    public BigDecimal getRequiredHours() {
        return this.requiredHours == null ? BigDecimal.ZERO : this.requiredHours;
    }

    public void setRequiredHours(BigDecimal requiredHours) {
        this.requiredHours = requiredHours;
    }

    public BigDecimal getWorkHour() {
        return this.workHour == null ? BigDecimal.ZERO : this.workHour;
    }

    public void setWorkHour(BigDecimal workHour) {
        this.workHour = workHour;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimesheetReminderLine)) {
            return false;
        }
        TimesheetReminderLine other = (TimesheetReminderLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("missingHours", (Object)this.getMissingHours()).add("extraHours", (Object)this.getExtraHours()).add("requiredHours", (Object)this.getRequiredHours()).add("workHour", (Object)this.getWorkHour()).omitNullValues().toString();
    }
}

