/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db.repo;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerBaseRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.PartnerHRRepository;
import com.axelor.apps.hr.db.repo.UserHRRepository;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.inject.Beans;

public class EmployeeHRRepository
extends EmployeeRepository {
    public Employee save(Employee entity) {
        Partner partner = entity.getContactPartner();
        if (!partner.getIsContact().booleanValue() && partner.getPartnerTypeSelect() == 0) {
            partner.setIsContact(true);
            partner.setIsEmployee(true);
            ((PartnerHRRepository)((Object)Beans.get(PartnerHRRepository.class))).save(partner);
        } else {
            ((PartnerService)Beans.get(PartnerService.class)).setPartnerFullName(partner);
        }
        EmploymentContract employmentContract = entity.getMainEmploymentContract();
        if (employmentContract != null && employmentContract.getEmployee() == null) {
            employmentContract.setEmployee(entity);
        }
        return (Employee)((Object)super.save((Model)((Object)entity)));
    }

    public Employee copy(Employee entity, boolean deep) {
        entity.setContactPartner(null);
        entity.setFixedProPhone(null);
        entity.setMobileProPhone(null);
        entity.setPhoneAtCustomer(null);
        entity.setEmergencyContact(null);
        entity.setEmergencyNumber(null);
        entity.setHireDate(null);
        entity.setSeniorityDate(null);
        entity.setProfitSharingBeneficiary(null);
        entity.setMainEmploymentContract(null);
        entity.setExportCode(null);
        entity.setEmploymentContractList(null);
        entity.setLunchVoucherAdvanceList(null);
        entity.setEmployeeAdvanceList(null);
        entity.setKilometricLogList(null);
        entity.setLeaveLineList(null);
        Employee copy = (Employee)((Object)super.copy((Model)((Object)entity), deep));
        return copy;
    }

    @Override
    public void remove(Employee employee) {
        PartnerBaseRepository partnerRepo;
        Partner partner;
        UserHRRepository userRepo;
        User user;
        if (employee.getUser() != null && (user = (User)((Object)(userRepo = (UserHRRepository)((Object)Beans.get(UserHRRepository.class))).find(employee.getUser().getId()))) != null) {
            user.setEmployee(null);
            userRepo.save(user);
        }
        super.remove(employee);
        if (employee.getContactPartner() != null && (partner = (Partner)((Object)(partnerRepo = (PartnerBaseRepository)Beans.get(PartnerBaseRepository.class)).find(employee.getContactPartner().getId()))) != null) {
            partner.setEmployee(null);
            partnerRepo.save(partner);
        }
    }
}

