/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db.repo;

import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.apps.hr.service.project.ProjectPlanningTimeService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectPlanningTime;
import com.axelor.apps.project.db.repo.ProjectManagementRepository;
import com.axelor.apps.project.db.repo.ProjectPlanningTimeRepository;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.google.inject.Inject;
import java.util.List;

public class ProjectHRRepository
extends ProjectManagementRepository {
    @Inject
    private ProjectPlanningTimeService projectPlanningTimeService;
    @Inject
    private ProjectPlanningTimeRepository planningTimeRepo;

    public Project save(Project project) {
        project = super.save(project);
        if (!((AppHumanResourceService)Beans.get(AppHumanResourceService.class)).isApp("employee")) {
            return project;
        }
        List projectPlanningTimeList = this.planningTimeRepo.all().filter("self.project = ?1 OR self.project.parentProject = ?1", new Object[]{project}).fetch();
        project.setTotalPlannedHrs(this.projectPlanningTimeService.getProjectPlannedHrs(project));
        Project parentProject = project.getParentProject();
        if (parentProject != null) {
            parentProject.setTotalPlannedHrs(this.projectPlanningTimeService.getProjectPlannedHrs(parentProject));
        }
        if (projectPlanningTimeList != null) {
            for (ProjectPlanningTime planningTime : projectPlanningTimeList) {
                TeamTask task = planningTime.getTask();
                if (task == null) continue;
                task.setTotalPlannedHrs(this.projectPlanningTimeService.getTaskPlannedHrs(task));
            }
        }
        return project;
    }
}

