/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db.repo;

import com.axelor.apps.hr.service.project.ProjectPlanningTimeService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectPlanningTime;
import com.axelor.apps.project.db.repo.ProjectPlanningTimeRepository;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.db.Model;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;

public class ProjectPlanningTimeHRRepository
extends ProjectPlanningTimeRepository {
    @Inject
    private ProjectPlanningTimeService planningTimeService;
    @Inject
    private ProjectRepository projectRepo;
    @Inject
    private TeamTaskRepository taskRepo;

    public ProjectPlanningTime save(ProjectPlanningTime projectPlanningTime) {
        TeamTask task;
        super.save((Model)((Object)projectPlanningTime));
        Project project = projectPlanningTime.getProject();
        project.setTotalPlannedHrs(this.planningTimeService.getProjectPlannedHrs(project));
        Project parentProject = project.getParentProject();
        if (parentProject != null) {
            parentProject.setTotalPlannedHrs(this.planningTimeService.getProjectPlannedHrs(parentProject));
        }
        if ((task = projectPlanningTime.getTask()) != null) {
            task.setTotalPlannedHrs(this.planningTimeService.getTaskPlannedHrs(task));
        }
        return projectPlanningTime;
    }

    public void remove(ProjectPlanningTime projectPlanningTime) {
        Project project = projectPlanningTime.getProject();
        TeamTask task = projectPlanningTime.getTask();
        super.remove((Model)((Object)projectPlanningTime));
        if (task != null) {
            this.taskRepo.save((Model)((Object)task));
        } else {
            this.projectRepo.save((Model)((Object)project));
        }
    }
}

