/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db.repo;

import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TimesheetLineHRRepository;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;

public class TimesheetHRRepository
extends TimesheetRepository {
    @Inject
    private TimesheetService timesheetService;
    @Inject
    private TimesheetLineService timesheetLineService;
    @Inject
    private ProjectRepository projectRepository;

    public Timesheet save(Timesheet timesheet) {
        if (timesheet.getTimesheetLineList() != null) {
            for (TimesheetLine timesheetLine : timesheet.getTimesheetLineList()) {
                ((TimesheetLineHRRepository)((Object)Beans.get(TimesheetLineHRRepository.class))).computeFullName(timesheetLine);
            }
        }
        return (Timesheet)((Object)super.save((Model)((Object)timesheet)));
    }

    public Map<String, Object> validate(Map<String, Object> json, Map<String, Object> context) {
        Timesheet timesheet;
        Map obj = super.validate(json, context);
        if (json.get("id") == null && ((timesheet = (Timesheet)((Object)this.create(json))).getTimesheetLineList() == null || timesheet.getTimesheetLineList().isEmpty())) {
            timesheet.setTimesheetLineList(new ArrayList<TimesheetLine>());
            obj.put("timesheetLineList", this.timesheetService.createDefaultLines(timesheet));
        }
        return obj;
    }

    public void remove(Timesheet entity) {
        if (entity.getStatusSelect() == 3 && entity.getTimesheetLineList() != null) {
            this.timesheetService.setTeamTaskTotalRealHrs(entity.getTimesheetLineList(), false);
            Map<Project, BigDecimal> projectTimeSpentMap = this.timesheetLineService.getProjectTimeSpentMap(entity.getTimesheetLineList());
            for (Project project : projectTimeSpentMap.keySet()) {
                project.setTimeSpent(project.getTimeSpent().subtract(projectTimeSpentMap.get((Object)project)));
                this.projectRepository.save((Model)((Object)project));
            }
        }
        super.remove((Model)((Object)entity));
    }
}

