/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.db.repo;

import com.axelor.apps.hr.db.TSTimer;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.TSTimerRepository;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.service.timesheet.timer.TimesheetTimerService;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public class TimesheetTimerHRRepository
extends TSTimerRepository {
    @Inject
    private TimesheetTimerService tsTimerService;

    public TSTimer save(TSTimer tsTimer) {
        if (tsTimer.getStatusSelect() == 3) {
            if (tsTimer.getTimesheetLine() != null) {
                this.updateTimesheetLine(tsTimer);
            } else if (tsTimer.getDuration() > 59L) {
                this.tsTimerService.generateTimesheetLine(tsTimer);
            }
        }
        return (TSTimer)((Object)super.save((Model)((Object)tsTimer)));
    }

    public void updateTimesheetLine(TSTimer tsTimer) {
        TimesheetLine timesheetLine = tsTimer.getTimesheetLine();
        timesheetLine.setProject(tsTimer.getProject());
        timesheetLine.setProduct(tsTimer.getProduct());
        timesheetLine.setHoursDuration(this.tsTimerService.convertSecondDurationInHours(tsTimer.getDuration()));
        timesheetLine.setComments(tsTimer.getComments());
        ((TimesheetLineRepository)((Object)Beans.get(TimesheetLineRepository.class))).save((Model)((Object)timesheetLine));
    }
}

