/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.mobile;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeVehicle;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.KilometricAllowParam;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.TimesheetLine;
import com.axelor.apps.hr.db.repo.EmployeeVehicleRepository;
import com.axelor.apps.hr.db.repo.ExpenseLineRepository;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.hr.db.repo.KilometricAllowParamRepository;
import com.axelor.apps.hr.db.repo.LeaveLineRepository;
import com.axelor.apps.hr.db.repo.LeaveReasonRepository;
import com.axelor.apps.hr.db.repo.LeaveRequestRepository;
import com.axelor.apps.hr.db.repo.TimesheetLineRepository;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.KilometricService;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.expense.ExpenseService;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.hr.service.timesheet.TimesheetLineService;
import com.axelor.apps.hr.service.timesheet.TimesheetService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.inject.persist.Transactional;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.math.BigDecimal;
import java.net.URLConnection;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HumanResourceMobileController {
    @Transactional(rollbackOn={Exception.class})
    public void insertKMExpenses(ActionRequest request, ActionResponse response) throws AxelorException {
        User user = AuthUtils.getUser();
        if (user != null) {
            ExpenseService expenseService = (ExpenseService)Beans.get(ExpenseService.class);
            Expense expense = expenseService.getOrCreateExpense(user);
            ExpenseLine expenseLine = new ExpenseLine();
            expenseLine.setDistance(new BigDecimal(request.getData().get("kmNumber").toString()));
            expenseLine.setFromCity(request.getData().get("locationFrom").toString());
            expenseLine.setToCity(request.getData().get("locationTo").toString());
            expenseLine.setKilometricTypeSelect(new Integer(request.getData().get("allowanceTypeSelect").toString()));
            expenseLine.setComments(request.getData().get("comments").toString());
            expenseLine.setExpenseDate(LocalDate.parse(request.getData().get("date").toString()));
            expenseLine.setProject((Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(Long.valueOf(request.getData().get("projectTask").toString()))));
            HRConfigService hrConfigService = (HRConfigService)Beans.get(HRConfigService.class);
            HRConfig hrConfig = hrConfigService.getHRConfig(expense.getCompany());
            Product expenseProduct = hrConfigService.getKilometricExpenseProduct(hrConfig);
            expenseLine.setExpenseProduct(expenseProduct);
            Employee employee = user.getEmployee();
            if (employee != null) {
                KilometricAllowParamRepository kilometricAllowParamRepo = (KilometricAllowParamRepository)((Object)Beans.get(KilometricAllowParamRepository.class));
                expenseLine.setKilometricAllowParam((KilometricAllowParam)((Object)kilometricAllowParamRepo.find(Long.valueOf(request.getData().get("kilometricAllowParam").toString()))));
                expenseLine.setTotalAmount(((KilometricService)Beans.get(KilometricService.class)).computeKilometricExpense(expenseLine, employee));
                expenseLine.setUntaxedAmount(expenseLine.getTotalAmount());
            }
            expense.addKilometricExpenseLineListItem(expenseLine);
            ((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).save((Model)((Object)expense));
            response.setValue("id", (Object)expenseLine.getId());
        }
    }

    @Transactional
    public void removeLines(ActionRequest request, ActionResponse response) {
        User user = AuthUtils.getUser();
        try {
            if (user == null) {
                return;
            }
            Expense expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).all().filter("self.statusSelect = ?1 AND self.user.id = ?2", new Object[]{1, user.getId()}).order("-id").fetchOne());
            if (expense == null) {
                return;
            }
            List<ExpenseLine> expenseLineList = ((ExpenseService)Beans.get(ExpenseService.class)).getExpenseLineList(expense);
            if (expenseLineList != null && !expenseLineList.isEmpty()) {
                Iterator<ExpenseLine> expenseLineIter = expenseLineList.iterator();
                while (expenseLineIter.hasNext()) {
                    ExpenseLine generalExpenseLine = expenseLineIter.next();
                    if (generalExpenseLine.getKilometricExpense() == null || (expense.getKilometricExpenseLineList() == null || expense.getKilometricExpenseLineList().contains((Object)generalExpenseLine)) && expense.getKilometricExpenseLineList() != null) continue;
                    expenseLineIter.remove();
                }
            }
            response.setValue("expenseLineList", expenseLineList);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void insertOrUpdateExpenseLine(ActionRequest request, ActionResponse response) {
        try {
            User user = AuthUtils.getUser();
            Map requestData = request.getData();
            Project project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(Long.valueOf(requestData.get("project").toString())));
            Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(Long.valueOf(requestData.get("expenseType").toString())));
            if (user != null) {
                ExpenseService expenseService = (ExpenseService)Beans.get(ExpenseService.class);
                Expense expense = expenseService.getOrCreateExpense(user);
                Object idO = requestData.get("id");
                ExpenseLine expenseLine = idO != null ? (ExpenseLine)((Object)((ExpenseLineRepository)((Object)Beans.get(ExpenseLineRepository.class))).find(Long.valueOf(idO.toString()))) : new ExpenseLine();
                expenseLine.setExpenseDate(LocalDate.parse(requestData.get("date").toString(), DateTimeFormatter.ISO_DATE));
                expenseLine.setComments(requestData.get("comments").toString());
                expenseLine.setExpenseProduct(product);
                expenseLine.setProject(project);
                expenseLine.setUser(user);
                expenseLine.setTotalAmount(new BigDecimal(requestData.get("unTaxTotal").toString()));
                expenseLine.setTotalTax(new BigDecimal(requestData.get("taxTotal").toString()));
                expenseLine.setUntaxedAmount(expenseLine.getTotalAmount().subtract(expenseLine.getTotalTax()));
                expenseLine.setToInvoice(new Boolean(requestData.get("toInvoice").toString()));
                String justification = (String)requestData.get("justification");
                if (!Strings.isNullOrEmpty((String)justification)) {
                    String MIME_IMAGE_X_ICON = "image/x-icon";
                    String MIME_IMAGE_SVG_XML = "image/svg+xml";
                    String MIME_IMAGE_BMP = "image/bmp";
                    String MIME_IMAGE_GIF = "image/gif";
                    String MIME_IMAGE_JPEG = "image/jpeg";
                    String MIME_IMAGE_TIFF = "image/tiff";
                    String MIME_IMAGE_PNG = "image/png";
                    HashMap<String, String> mimeTypeMapping = new HashMap<String, String>(200);
                    mimeTypeMapping.put(MIME_IMAGE_X_ICON, "ico");
                    mimeTypeMapping.put(MIME_IMAGE_SVG_XML, "svg");
                    mimeTypeMapping.put(MIME_IMAGE_BMP, "bmp");
                    mimeTypeMapping.put(MIME_IMAGE_GIF, "gif");
                    mimeTypeMapping.put(MIME_IMAGE_JPEG, "jpg");
                    mimeTypeMapping.put(MIME_IMAGE_TIFF, "tif");
                    mimeTypeMapping.put(MIME_IMAGE_PNG, "png");
                    byte[] decodedFile = Base64.getDecoder().decode(justification);
                    String formatName = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(decodedFile));
                    String extension = "";
                    if (mimeTypeMapping.containsKey(formatName)) {
                        extension = "." + (String)mimeTypeMapping.get(formatName);
                        File file = MetaFiles.createTempFile((String)"justification", (String)extension, (FileAttribute[])new FileAttribute[0]).toFile();
                        Files.write((byte[])decodedFile, (File)file);
                        MetaFile metaFile = ((MetaFiles)Beans.get(MetaFiles.class)).upload(file);
                        expenseLine.setJustificationMetaFile(metaFile);
                    }
                }
                expense.addGeneralExpenseLineListItem(expenseLine);
                expense = expenseService.compute(expense);
                ((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).save((Model)((Object)expense));
                HashMap<String, Long> data = new HashMap<String, Long>();
                data.put("id", expenseLine.getId());
                response.setData(data);
                response.setTotal(1L);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    @Transactional
    public void getActivities(ActionRequest request, ActionResponse response) {
        ArrayList dataList = new ArrayList();
        try {
            List productList = ((ProductRepository)((Object)Beans.get(ProductRepository.class))).all().filter("self.isActivity = true AND self.dtype = 'Product'").fetch();
            for (Product product : productList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", product.getName());
                map.put("id", product.getId().toString());
                dataList.add(map);
            }
            response.setData(dataList);
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setError(e.getMessage());
        }
    }

    @Transactional
    public void insertOrUpdateTSLine(ActionRequest request, ActionResponse response) {
        try {
            Map requestData = request.getData();
            User user = AuthUtils.getUser();
            Project project = (Project)((Object)((ProjectRepository)((Object)Beans.get(ProjectRepository.class))).find(new Long(request.getData().get("project").toString())));
            Product product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(new Long(request.getData().get("activity").toString())));
            LocalDate date = LocalDate.parse(request.getData().get("date").toString(), DateTimeFormatter.ISO_DATE);
            TimesheetRepository timesheetRepository = (TimesheetRepository)((Object)Beans.get(TimesheetRepository.class));
            TimesheetService timesheetService = (TimesheetService)Beans.get(TimesheetService.class);
            TimesheetLineService timesheetLineService = (TimesheetLineService)Beans.get(TimesheetLineService.class);
            if (user != null) {
                Timesheet timesheet = (Timesheet)((Object)timesheetRepository.all().filter("self.statusSelect = 1 AND self.user.id = ?1", new Object[]{user.getId()}).order("-id").fetchOne());
                if (timesheet == null) {
                    timesheet = timesheetService.createTimesheet(user, date, date);
                }
                BigDecimal hours = new BigDecimal(request.getData().get("duration").toString());
                Object idO = requestData.get("id");
                TimesheetLine line = idO != null ? timesheetLineService.updateTimesheetLine((TimesheetLine)((Object)((TimesheetLineRepository)((Object)Beans.get(TimesheetLineRepository.class))).find(Long.valueOf(idO.toString()))), project, product, user, date, timesheet, hours, request.getData().get("comments").toString()) : timesheetLineService.createTimesheetLine(project, product, user, date, timesheet, hours, request.getData().get("comments").toString());
                BigDecimal duration = timesheetLineService.computeHoursDuration(timesheet, hours, false);
                line.setDuration(duration);
                timesheet.addTimesheetLineListItem(line);
                timesheetRepository.save((Model)((Object)timesheet));
                response.setTotal(1L);
                HashMap<String, Long> data = new HashMap<String, Long>();
                data.put("id", line.getId());
                response.setData(data);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void insertLeave(ActionRequest request, ActionResponse response) throws AxelorException {
        AppBaseService appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        User user = AuthUtils.getUser();
        Map requestData = request.getData();
        LeaveReason leaveReason = (LeaveReason)((Object)((LeaveReasonRepository)((Object)Beans.get(LeaveReasonRepository.class))).find(Long.valueOf(requestData.get("leaveReason").toString())));
        Employee employee = user.getEmployee();
        if (employee == null) {
            throw new AxelorException(4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{user.getName()});
        }
        if (leaveReason != null) {
            LeaveRequest leave = new LeaveRequest();
            leave.setUser(user);
            Company company = null;
            if (employee.getMainEmploymentContract() != null) {
                company = employee.getMainEmploymentContract().getPayCompany();
            }
            leave.setCompany(company);
            LeaveLine leaveLine = (LeaveLine)((Object)((LeaveLineRepository)((Object)Beans.get(LeaveLineRepository.class))).all().filter("self.employee = ?1 AND self.leaveReason = ?2", new Object[]{employee, leaveReason}).fetchOne());
            if (leaveLine == null) {
                throw new AxelorException(4, I18n.get((String)"There is no leave line for the employee %s and the reason %s."), new Object[]{employee.getName(), leaveReason.getLeaveReason()});
            }
            leave.setLeaveLine(leaveLine);
            leave.setRequestDate(appBaseService.getTodayDate(company));
            if (requestData.get("fromDateT") != null) {
                leave.setFromDateT(LocalDateTime.parse(requestData.get("fromDateT").toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            }
            leave.setStartOnSelect(new Integer(requestData.get("startOn").toString()));
            if (requestData.get("toDateT") != null) {
                leave.setToDateT(LocalDateTime.parse(requestData.get("toDateT").toString(), DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            }
            leave.setEndOnSelect(new Integer(requestData.get("endOn").toString()));
            leave.setDuration(((LeaveService)Beans.get(LeaveService.class)).computeDuration(leave));
            leave.setStatusSelect(2);
            if (requestData.get("comments") != null) {
                leave.setComments(requestData.get("comments").toString());
            }
            leave = (LeaveRequest)((Object)((LeaveRequestRepository)((Object)Beans.get(LeaveRequestRepository.class))).save((Model)((Object)leave)));
            response.setTotal(1L);
            response.setValue("id", (Object)leave.getId());
        }
    }

    @Transactional
    public void getLeaveReason(ActionRequest request, ActionResponse response) {
        try {
            User user = AuthUtils.getUser();
            ArrayList dataList = new ArrayList();
            if (user == null || user.getEmployee() == null) {
                List leaveReasonList = ((LeaveReasonRepository)((Object)Beans.get(LeaveReasonRepository.class))).all().fetch();
                for (LeaveReason leaveReason : leaveReasonList) {
                    if (leaveReason.getUnitSelect() != 1) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("name", leaveReason.getLeaveReason());
                    map.put("id", leaveReason.getId().toString());
                    dataList.add(map);
                }
            } else if (user.getEmployee() != null) {
                List leaveLineList = ((LeaveLineRepository)((Object)Beans.get(LeaveLineRepository.class))).all().filter("self.employee = ?1", new Object[]{user.getEmployee()}).order("name").fetch();
                String tmpName = "";
                for (LeaveLine leaveLine : leaveLineList) {
                    String name = leaveLine.getName();
                    if (tmpName != name) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("name", leaveLine.getName());
                        map.put("id", leaveLine.getLeaveReason().getId().toString());
                        map.put("quantity", leaveLine.getQuantity().toString());
                        dataList.add(map);
                    }
                    tmpName = name;
                }
            }
            response.setData(dataList);
            response.setTotal((long)dataList.size());
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setError(e.getMessage());
        }
    }

    @Transactional
    public void getExpensesTypes(ActionRequest request, ActionResponse response) {
        ArrayList dataList = new ArrayList();
        try {
            List productList = ((ProductRepository)((Object)Beans.get(ProductRepository.class))).all().filter("self.expense = true AND coalesce(self.unavailableToUsers, false) = false AND coalesce(self.personalExpense, false) = false AND self.dtype = 'Product'").fetch();
            for (Product product : productList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", product.getName());
                map.put("id", product.getId().toString());
                dataList.add(map);
            }
            response.setData(dataList);
            response.setTotal((long)dataList.size());
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setError(e.getMessage());
        }
    }

    @Transactional
    public void getKilometricAllowParam(ActionRequest request, ActionResponse response) {
        ArrayList dataList = new ArrayList();
        try {
            User user = AuthUtils.getUser();
            List employeeVehicleList = ((EmployeeVehicleRepository)((Object)Beans.get(EmployeeVehicleRepository.class))).all().filter("self.employee = ?1", new Object[]{user.getEmployee()}).fetch();
            employeeVehicleList.sort((employeeVehicle1, employeeVehicle2) -> employeeVehicle1.getKilometricAllowParam().getCode().compareTo(employeeVehicle2.getKilometricAllowParam().getCode()));
            for (EmployeeVehicle employeeVehicle : employeeVehicleList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", employeeVehicle.getKilometricAllowParam().getName());
                map.put("id", employeeVehicle.getKilometricAllowParam().getId().toString());
                dataList.add(map);
            }
            response.setData(dataList);
        }
        catch (Exception e) {
            response.setStatus(-1);
            response.setError(e.getMessage());
        }
    }
}

