/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeBonusMgtLine;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.ExtraHoursLine;
import com.axelor.apps.hr.db.ExtraHoursType;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.LunchVoucherMgtLine;
import com.axelor.apps.hr.db.PayrollLeave;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.apps.hr.db.repo.EmployeeBonusMgtLineRepository;
import com.axelor.apps.hr.db.repo.EmployeeBonusMgtRepository;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.hr.db.repo.ExtraHoursLineRepository;
import com.axelor.apps.hr.db.repo.LeaveRequestRepository;
import com.axelor.apps.hr.db.repo.LunchVoucherMgtLineRepository;
import com.axelor.apps.hr.db.repo.PayrollPreparationRepository;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PayrollPreparationService {
    protected LeaveService leaveService;
    protected LeaveRequestRepository leaveRequestRepo;
    protected WeeklyPlanningService weeklyPlanningService;
    @Inject
    protected PayrollPreparationRepository payrollPreparationRepo;
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    HRConfigService hrConfigService;

    @Inject
    public PayrollPreparationService(LeaveService leaveService, LeaveRequestRepository leaveRequestRepo, WeeklyPlanningService weeklyPlanningService) {
        this.leaveService = leaveService;
        this.leaveRequestRepo = leaveRequestRepo;
        this.weeklyPlanningService = weeklyPlanningService;
    }

    public PayrollPreparation generateFromEmploymentContract(PayrollPreparation payrollPreparation, EmploymentContract employmentContract) {
        if (payrollPreparation.getEmployee() == null) {
            payrollPreparation.setEmployee(employmentContract.getEmployee());
        }
        if (payrollPreparation.getCompany() == null) {
            payrollPreparation.setCompany(employmentContract.getPayCompany());
        }
        if (payrollPreparation.getEmploymentContract() == null) {
            payrollPreparation.setEmploymentContract(employmentContract);
        }
        payrollPreparation.setOtherCostsEmployeeSet(employmentContract.getOtherCostsEmployeeSet());
        payrollPreparation.setAnnualGrossSalary(employmentContract.getAnnualGrossSalary());
        return payrollPreparation;
    }

    public List<PayrollLeave> fillInPayrollPreparation(PayrollPreparation payrollPreparation) throws AxelorException {
        List<PayrollLeave> payrollLeaveList = this.fillInLeaves(payrollPreparation);
        payrollPreparation.setDuration(this.computeWorkingDaysNumber(payrollPreparation, payrollLeaveList));
        payrollPreparation.setExpenseAmount(this.computeExpenseAmount(payrollPreparation));
        payrollPreparation.setLunchVoucherNumber(this.computeLunchVoucherNumber(payrollPreparation));
        payrollPreparation.setEmployeeBonusAmount(this.computeEmployeeBonusAmount(payrollPreparation));
        payrollPreparation.setExtraHoursNumber(this.computeExtraHoursNumber(payrollPreparation));
        return payrollLeaveList;
    }

    public List<PayrollLeave> fillInLeaves(PayrollPreparation payrollPreparation) throws AxelorException {
        ArrayList<PayrollLeave> payrollLeaveList = new ArrayList<PayrollLeave>();
        LocalDate fromDate = payrollPreparation.getPeriod().getFromDate();
        LocalDate toDate = payrollPreparation.getPeriod().getToDate();
        Employee employee = payrollPreparation.getEmployee();
        if (employee.getWeeklyPlanning() == null) {
            throw new AxelorException((Model)((Object)payrollPreparation), 4, I18n.get((String)"Please, add a planning for employee : %s"), new Object[]{employee.getName()});
        }
        List leaveRequestList = this.leaveRequestRepo.all().filter("self.statusSelect = ?4 AND self.user.employee = ?3 AND ((self.fromDateT BETWEEN ?2 AND ?1 OR self.toDateT BETWEEN ?2 AND ?1) OR (?1 BETWEEN self.fromDateT AND self.toDateT OR ?2 BETWEEN self.fromDateT AND self.toDateT))", new Object[]{toDate, fromDate, employee, 3}).fetch();
        for (LeaveRequest leaveRequest : leaveRequestList) {
            PayrollLeave payrollLeave = new PayrollLeave();
            if (leaveRequest.getFromDateT().toLocalDate().isBefore(fromDate)) {
                payrollLeave.setFromDate(fromDate);
            } else {
                payrollLeave.setFromDate(leaveRequest.getFromDateT().toLocalDate());
            }
            if (leaveRequest.getToDateT().toLocalDate().isAfter(toDate)) {
                payrollLeave.setToDate(toDate);
            } else {
                payrollLeave.setToDate(leaveRequest.getToDateT().toLocalDate());
            }
            payrollLeave.setDuration(this.leaveService.computeLeaveDaysByLeaveRequest(fromDate, toDate, leaveRequest, employee));
            payrollLeave.setLeaveReason(leaveRequest.getLeaveLine().getLeaveReason());
            payrollLeave.setLeaveRequest(leaveRequest);
            payrollLeaveList.add(payrollLeave);
        }
        return payrollLeaveList;
    }

    public BigDecimal computeWorkingDaysNumber(PayrollPreparation payrollPreparation, List<PayrollLeave> payrollLeaveList) {
        LocalDate fromDate = payrollPreparation.getPeriod().getFromDate();
        LocalDate toDate = payrollPreparation.getPeriod().getToDate();
        LocalDate itDate = LocalDate.parse(fromDate.toString(), DateTimeFormatter.ISO_DATE);
        BigDecimal workingDays = BigDecimal.ZERO;
        BigDecimal leaveDays = BigDecimal.ZERO;
        while (!itDate.isAfter(toDate)) {
            workingDays = workingDays.add(BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDays(payrollPreparation.getEmployee().getWeeklyPlanning(), itDate)));
            itDate = itDate.plusDays(1L);
        }
        if (payrollLeaveList != null) {
            for (PayrollLeave payrollLeave : payrollLeaveList) {
                workingDays = workingDays.subtract(payrollLeave.getDuration());
                leaveDays = leaveDays.add(payrollLeave.getDuration());
            }
        }
        payrollPreparation.setLeaveDuration(leaveDays);
        return workingDays;
    }

    public BigDecimal computeExtraHoursNumber(PayrollPreparation payrollPreparation) {
        LocalDate fromDate = payrollPreparation.getPeriod().getFromDate();
        LocalDate toDate = payrollPreparation.getPeriod().getToDate();
        BigDecimal extraHoursNumber = BigDecimal.ZERO;
        for (ExtraHoursLine extraHoursLine : ((ExtraHoursLineRepository)((Object)Beans.get(ExtraHoursLineRepository.class))).all().filter("self.user.employee = ?1 AND self.extraHours.statusSelect = 3 AND self.date BETWEEN ?2 AND ?3 AND (self.payrollPreparation = null OR self.payrollPreparation.id = ?4)", new Object[]{payrollPreparation.getEmployee(), fromDate, toDate, payrollPreparation.getId()}).fetch()) {
            payrollPreparation.addExtraHoursLineListItem(extraHoursLine);
            extraHoursNumber = extraHoursNumber.add(extraHoursLine.getQty());
        }
        return extraHoursNumber;
    }

    public BigDecimal computeExpenseAmount(PayrollPreparation payrollPreparation) {
        BigDecimal expenseAmount = BigDecimal.ZERO;
        List expenseList = ((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).all().filter("self.user.employee = ?1 AND self.statusSelect = ?2 AND (self.payrollPreparation IS NULL OR self.payrollPreparation.id = ?3) AND self.companyCbSelect = ?4 AND self.validationDate BETWEEN ?5 AND ?6", new Object[]{payrollPreparation.getEmployee(), 3, payrollPreparation.getId(), 1, payrollPreparation.getPeriod().getFromDate(), payrollPreparation.getPeriod().getToDate()}).fetch();
        for (Expense expense : expenseList) {
            expenseAmount = expenseAmount.add(expense.getInTaxTotal());
            payrollPreparation.addExpenseListItem(expense);
        }
        return expenseAmount;
    }

    public BigDecimal computeLunchVoucherNumber(PayrollPreparation payrollPreparation) {
        BigDecimal lunchVoucherNumber = BigDecimal.ZERO;
        List lunchVoucherList = ((LunchVoucherMgtLineRepository)((Object)Beans.get(LunchVoucherMgtLineRepository.class))).all().filter("self.employee = ?1 AND self.lunchVoucherMgt.statusSelect = 3 AND (self.payrollPreparation = null OR self.payrollPreparation.id = ?2) AND self.lunchVoucherMgt.payPeriod = ?3", new Object[]{payrollPreparation.getEmployee(), payrollPreparation.getId(), payrollPreparation.getPeriod()}).fetch();
        for (LunchVoucherMgtLine lunchVoucherMgtLine : lunchVoucherList) {
            lunchVoucherNumber = lunchVoucherNumber.add(new BigDecimal(lunchVoucherMgtLine.getLunchVoucherNumber()));
            lunchVoucherNumber = lunchVoucherNumber.add(new BigDecimal(lunchVoucherMgtLine.getInAdvanceNbr()));
            payrollPreparation.addLunchVoucherMgtLineListItem(lunchVoucherMgtLine);
        }
        return lunchVoucherNumber;
    }

    public BigDecimal computeEmployeeBonusAmount(PayrollPreparation payrollPreparation) {
        BigDecimal employeeBonusAmount = BigDecimal.ZERO;
        List employeeBonusList = ((EmployeeBonusMgtLineRepository)((Object)Beans.get(EmployeeBonusMgtLineRepository.class))).all().filter("self.employee = ?1 AND self.employeeBonusMgt.statusSelect = ?4 AND (self.payrollPreparation = null OR self.payrollPreparation.id = ?2) AND self.employeeBonusMgt.payPeriod = ?3", new Object[]{payrollPreparation.getEmployee(), payrollPreparation.getId(), payrollPreparation.getPeriod(), EmployeeBonusMgtRepository.STATUS_CALCULATED}).fetch();
        for (EmployeeBonusMgtLine employeeBonusMgtLine : employeeBonusList) {
            payrollPreparation.addEmployeeBonusMgtLineListItem(employeeBonusMgtLine);
            employeeBonusAmount = employeeBonusAmount.add(employeeBonusMgtLine.getAmount());
        }
        return employeeBonusAmount;
    }

    @Transactional(rollbackOn={Exception.class})
    public String exportPayrollPreparation(PayrollPreparation payrollPreparation) throws AxelorException, IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] headerLine = new String[]{};
        if (payrollPreparation.getExportTypeSelect() == 1) {
            String[] item = new String[]{payrollPreparation.getEmployee().getName(), payrollPreparation.getDuration().toString(), payrollPreparation.getLunchVoucherNumber().toString(), payrollPreparation.getEmployeeBonusAmount().toString(), payrollPreparation.getExtraHoursNumber().toString()};
            list.add(item);
            headerLine = this.getPayrollPreparationExportHeader();
        } else if (payrollPreparation.getExportTypeSelect() == 2) {
            this.exportNibelis(payrollPreparation, list);
            headerLine = this.getPayrollPreparationMeilleurGestionExportHeader();
        } else if (payrollPreparation.getExportTypeSelect() == 3) {
            this.exportSilae(payrollPreparation, list);
            headerLine = this.getPayrollPreparationSilaeExportHeader();
        }
        String fileName = this.getPayrollPreparationExportName();
        String filePath = AppSettings.get().get("file.upload.dir");
        new File(filePath).mkdirs();
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)';', (String[])headerLine, list);
        Path path = Paths.get(filePath + System.getProperty("file.separator") + fileName, new String[0]);
        try (FileInputStream is = new FileInputStream(path.toFile());){
            ((MetaFiles)Beans.get(MetaFiles.class)).attach((InputStream)is, fileName, (Model)((Object)payrollPreparation));
        }
        payrollPreparation.setExported(true);
        payrollPreparation.setExportDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(payrollPreparation.getCompany()));
        this.payrollPreparationRepo.save((Model)((Object)payrollPreparation));
        return filePath + System.getProperty("file.separator") + fileName;
    }

    public String[] createExportFileLine(PayrollPreparation payrollPreparation) {
        String[] item = new String[7];
        item[0] = payrollPreparation.getEmployee().getExportCode();
        item[1] = payrollPreparation.getEmployee().getContactPartner().getName();
        item[2] = payrollPreparation.getEmployee().getContactPartner().getFirstName();
        return item;
    }

    public void exportNibelis(PayrollPreparation payrollPreparation, List<String[]> list) throws AxelorException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(payrollPreparation.getCompany());
        if (payrollPreparation.getLeaveDuration().compareTo(BigDecimal.ZERO) > 0) {
            List<PayrollLeave> payrollLeaveList = this.fillInLeaves(payrollPreparation);
            for (PayrollLeave payrollLeave : payrollLeaveList) {
                if (!payrollLeave.getLeaveReason().getPayrollPreprationExport().booleanValue()) continue;
                String[] leaveLine = this.createExportFileLine(payrollPreparation);
                leaveLine[3] = payrollLeave.getLeaveReason().getExportCode();
                leaveLine[4] = payrollLeave.getFromDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
                leaveLine[5] = payrollLeave.getToDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
                leaveLine[6] = payrollLeave.getDuration().toString();
                list.add(leaveLine);
            }
        }
        if (payrollPreparation.getLunchVoucherNumber().compareTo(BigDecimal.ZERO) > 0) {
            String[] lunchVoucherLine = this.createExportFileLine(payrollPreparation);
            lunchVoucherLine[3] = hrConfig.getExportCodeForLunchVoucherManagement();
            lunchVoucherLine[6] = payrollPreparation.getLunchVoucherNumber().toString();
            list.add(lunchVoucherLine);
        }
        if (payrollPreparation.getEmployeeBonusAmount().compareTo(BigDecimal.ZERO) > 0) {
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            for (EmployeeBonusMgtLine employeeBonusMgtLine : payrollPreparation.getEmployeeBonusMgtLineList()) {
                if (!employeeBonusMgtLine.getEmployeeBonusMgt().getEmployeeBonusType().getPayrollPreparationExport().booleanValue()) continue;
                if (map.containsKey(employeeBonusMgtLine.getEmployeeBonusMgt().getEmployeeBonusType().getExportCode())) {
                    map.put(employeeBonusMgtLine.getEmployeeBonusMgt().getEmployeeBonusType().getExportCode(), employeeBonusMgtLine.getAmount().add((BigDecimal)map.get(employeeBonusMgtLine.getEmployeeBonusMgt().getEmployeeBonusType().getExportCode())));
                    continue;
                }
                map.put(employeeBonusMgtLine.getEmployeeBonusMgt().getEmployeeBonusType().getExportCode(), employeeBonusMgtLine.getAmount());
            }
            for (Map.Entry entry : map.entrySet()) {
                String[] employeeBonusLine = this.createExportFileLine(payrollPreparation);
                employeeBonusLine[3] = (String)entry.getKey();
                employeeBonusLine[6] = ((BigDecimal)entry.getValue()).toString();
                list.add(employeeBonusLine);
            }
        }
        if (payrollPreparation.getExtraHoursNumber().compareTo(BigDecimal.ZERO) > 0) {
            List extraHourLineList = ((ExtraHoursLineRepository)((Object)Beans.get(ExtraHoursLineRepository.class))).all().filter("self.payrollPreparation.id = ?1 AND self.extraHoursType.payrollPreprationExport = ?2", new Object[]{payrollPreparation.getId(), true}).fetch();
            Map<ExtraHoursType, BigDecimal> extraHourLineExportMap = extraHourLineList.stream().collect(Collectors.groupingBy(ExtraHoursLine::getExtraHoursType, Collectors.reducing(BigDecimal.ZERO, ExtraHoursLine::getQty, BigDecimal::add)));
            extraHourLineExportMap.forEach((extraHoursTypeGroup, totalHours) -> {
                String[] extraHourLine = this.createExportFileLine(payrollPreparation);
                extraHourLine[3] = extraHoursTypeGroup.getExportCode();
                extraHourLine[6] = totalHours.toString();
                list.add(extraHourLine);
            });
        }
    }

    public String getPayrollPreparationExportName() {
        return I18n.get((String)"Payroll preparation") + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime().toString() + ".csv";
    }

    public String[] getPayrollPreparationExportHeader() {
        String[] headers = new String[]{I18n.get((String)"Employee"), I18n.get((String)"Working days' number"), I18n.get((String)"Lunch vouchers' number"), I18n.get((String)"Employee bonus amount"), I18n.get((String)"Extra hours' number")};
        return headers;
    }

    public String[] getPayrollPreparationMeilleurGestionExportHeader() {
        String[] headers = new String[]{I18n.get((String)"Registration number"), I18n.get((String)"Employee lastname"), I18n.get((String)"Employee firstname"), I18n.get((String)"Code"), I18n.get((String)"Start date"), I18n.get((String)"End date"), I18n.get((String)"Value")};
        return headers;
    }

    @Transactional
    public void closePayPeriodIfExported(PayrollPreparation payrollPreparation) {
        Company company = payrollPreparation.getCompany();
        Period payPeriod = payrollPreparation.getPeriod();
        long nbNotExportedPayroll = ((PayrollPreparationRepository)((Object)Beans.get(PayrollPreparationRepository.class))).all().filter("self.company = :_company AND self.exported = false AND self.period = :_period").bind("_company", (Object)company).bind("_period", (Object)payPeriod).count();
        if (nbNotExportedPayroll == 0L) {
            payPeriod.setStatusSelect(2);
            payPeriod.setClosureDateTime(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
        }
        ((PeriodRepository)((Object)Beans.get(PeriodRepository.class))).save((Model)((Object)payPeriod));
    }

    public List<String[]> exportSilae(PayrollPreparation payrollPrep, List<String[]> exportLineList) throws AxelorException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(payrollPrep.getCompany());
        if (payrollPrep.getLeaveDuration().compareTo(BigDecimal.ZERO) > 0) {
            List<PayrollLeave> payrollLeaveList = this.fillInLeaves(payrollPrep);
            for (PayrollLeave payrollLeave : payrollLeaveList) {
                if (!payrollLeave.getLeaveReason().getPayrollPreprationExport().booleanValue()) continue;
                String[] leaveLine = this.createSilaeExportFileLine(payrollPrep);
                leaveLine[1] = payrollLeave.getLeaveReason().getExportCode();
                leaveLine[2] = String.valueOf(payrollLeave.getDuration());
                leaveLine[3] = payrollLeave.getFromDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
                leaveLine[4] = payrollLeave.getToDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
                exportLineList.add(leaveLine);
            }
        }
        String[] durationLine = this.createSilaeExportFileLine(payrollPrep);
        durationLine[1] = hrConfig.getExportCodeForDuration();
        durationLine[2] = String.valueOf(payrollPrep.getDuration());
        exportLineList.add(durationLine);
        String[] extraHoursLine = this.createSilaeExportFileLine(payrollPrep);
        extraHoursLine[1] = hrConfig.getExportCodeForExtraHours();
        extraHoursLine[2] = String.valueOf(payrollPrep.getExtraHoursNumber());
        exportLineList.add(extraHoursLine);
        return exportLineList;
    }

    public String[] getPayrollPreparationSilaeExportHeader() {
        String[] headers = new String[]{I18n.get((String)"Registration number"), I18n.get((String)"Code"), I18n.get((String)"Value"), I18n.get((String)"Start date"), I18n.get((String)"End date")};
        return headers;
    }

    public String[] createSilaeExportFileLine(PayrollPreparation payroll) {
        String[] item = new String[5];
        item[0] = payroll.getEmployee().getExportCode();
        item[3] = payroll.getPeriod().getFromDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        item[4] = payroll.getPeriod().getToDate().format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
        return item;
    }
}

