/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.app;

import com.axelor.apps.base.db.AppExpense;
import com.axelor.apps.base.db.AppLeave;
import com.axelor.apps.base.db.AppTimesheet;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.repo.AppExpenseRepository;
import com.axelor.apps.base.db.repo.AppLeaveRepository;
import com.axelor.apps.base.db.repo.AppTimesheetRepository;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.service.app.AppBaseServiceImpl;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.repo.HRConfigRepository;
import com.axelor.apps.hr.service.app.AppHumanResourceService;
import com.axelor.db.Model;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.HashMap;
import java.util.List;

@Singleton
public class AppHumanResourceServiceImpl
extends AppBaseServiceImpl
implements AppHumanResourceService {
    private AppTimesheetRepository appTimesheetRepo;
    private AppLeaveRepository appLeaveRepo;
    private AppExpenseRepository appExpenseRepo;
    @Inject
    private CompanyRepository companyRepo;
    @Inject
    private HRConfigRepository hrConfigRepo;

    @Inject
    public AppHumanResourceServiceImpl(AppTimesheetRepository appTimesheetRepo, AppLeaveRepository appLeaveRepo, AppExpenseRepository appExpense) {
        this.appTimesheetRepo = appTimesheetRepo;
        this.appLeaveRepo = appLeaveRepo;
        this.appExpenseRepo = appExpense;
    }

    @Override
    public AppTimesheet getAppTimesheet() {
        return (AppTimesheet)((Object)this.appTimesheetRepo.all().fetchOne());
    }

    @Override
    public AppLeave getAppLeave() {
        return (AppLeave)((Object)this.appLeaveRepo.all().fetchOne());
    }

    @Override
    public AppExpense getAppExpense() {
        return (AppExpense)((Object)this.appExpenseRepo.all().fetchOne());
    }

    @Override
    public void getHrmAppSettings(ActionRequest request, ActionResponse response) {
        try {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("hasInvoicingAppEnable", this.isApp("invoice"));
            map.put("hasLeaveAppEnable", this.isApp("leave"));
            map.put("hasExpenseAppEnable", this.isApp("expense"));
            map.put("hasTimesheetAppEnable", this.isApp("timesheet"));
            map.put("hasProjectAppEnable", this.isApp("project"));
            response.setData(map);
            response.setTotal((long)map.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setException((Throwable)e);
        }
    }

    @Override
    @Transactional
    public void generateHrConfigurations() {
        List companies = this.companyRepo.all().filter("self.hrConfig is null").fetch();
        for (Company company : companies) {
            HRConfig hrConfig = new HRConfig();
            hrConfig.setCompany(company);
            this.hrConfigRepo.save((Model)((Object)hrConfig));
        }
    }
}

