/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.bankorder;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderCreateService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Expense;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankOrderCreateServiceHr
extends BankOrderCreateService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public BankOrderCreateServiceHr(BankOrderRepository bankOrderRepo, BankOrderService bankOrderService, BankOrderLineService bankOrderLineService, InvoiceService invoiceService) {
        super(bankOrderRepo, bankOrderService, bankOrderLineService, invoiceService);
    }

    public BankOrder createBankOrder(Expense expense, BankDetails bankDetails) throws AxelorException {
        Company company = expense.getCompany();
        Partner partner = expense.getUser().getPartner();
        PaymentMode paymentMode = expense.getPaymentMode();
        BigDecimal amount = expense.getInTaxTotal().subtract(expense.getAdvanceAmount()).subtract(expense.getWithdrawnCash()).subtract(expense.getPersonalExpenseAmount());
        Currency currency = company.getCurrency();
        LocalDate paymentDate = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company);
        BankOrder bankOrder = super.createBankOrder(paymentMode, Integer.valueOf(2), paymentDate, company, bankDetails, currency, expense.getFullName(), expense.getFullName(), 1);
        bankOrder.addBankOrderLineListItem(this.bankOrderLineService.createBankOrderLine(paymentMode.getBankOrderFileFormat(), partner, amount, currency, paymentDate, expense.getExpenseSeq(), expense.getFullName(), (Model)((Object)expense)));
        bankOrder = (BankOrder)this.bankOrderRepo.save((Model)bankOrder);
        return bankOrder;
    }

    public BankOrder createBankOrder(Expense expense) throws AxelorException {
        return this.createBankOrder(expense, expense.getCompany().getDefaultBankDetails());
    }
}

