/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.bankorder;

import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCancelService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.ebics.service.EbicsService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineOriginService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderMoveService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderServiceImpl;
import com.axelor.apps.bankpayment.service.config.BankPaymentConfigService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.hr.service.expense.ExpenseService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;

public class BankOrderServiceHRImpl
extends BankOrderServiceImpl {
    protected ExpenseService expenseService;

    @Inject
    public BankOrderServiceHRImpl(BankOrderRepository bankOrderRepo, InvoicePaymentRepository invoicePaymentRepo, BankOrderLineService bankOrderLineService, EbicsService ebicsService, InvoicePaymentCancelService invoicePaymentCancelService, BankPaymentConfigService bankPaymentConfigService, SequenceService sequenceService, BankOrderLineOriginService bankOrderLineOriginService, ExpenseService expenseService, BankOrderMoveService bankOrderMoveService, AppBaseService appBaseService) {
        super(bankOrderRepo, invoicePaymentRepo, bankOrderLineService, ebicsService, invoicePaymentCancelService, bankPaymentConfigService, sequenceService, bankOrderLineOriginService, bankOrderMoveService, appBaseService);
        this.expenseService = expenseService;
    }

    @Transactional(rollbackOn={Exception.class})
    public void validatePayment(BankOrder bankOrder) throws AxelorException {
        super.validatePayment(bankOrder);
        if (!((AppService)Beans.get(AppService.class)).isApp("employee")) {
            return;
        }
        List expenseList = ((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).all().filter("self.bankOrder.id = ?", new Object[]{bankOrder.getId()}).fetch();
        for (Expense expense : expenseList) {
            if (expense == null || expense.getStatusSelect() == 4) continue;
            expense.setStatusSelect(4);
            expense.setPaymentStatusSelect(1);
            this.expenseService.createMoveForExpensePayment(expense);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void cancelPayment(BankOrder bankOrder) throws AxelorException {
        super.cancelPayment(bankOrder);
        if (!((AppService)Beans.get(AppService.class)).isApp("employee")) {
            return;
        }
        List expenseList = ((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).all().filter("self.bankOrder.id = ?", new Object[]{bankOrder.getId()}).fetch();
        for (Expense expense : expenseList) {
            if (expense == null || expense.getPaymentStatusSelect() == 2) continue;
            this.expenseService.cancelPayment(expense);
        }
    }
}

