/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.HrBatch;
import com.axelor.apps.hr.db.repo.EmploymentContractRepository;
import com.axelor.apps.hr.db.repo.HrBatchRepository;
import com.axelor.apps.hr.service.EmploymentContractService;
import com.axelor.apps.hr.service.batch.BatchStrategy;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class BatchEmploymentContractExport
extends BatchStrategy {
    protected int total;
    protected HrBatch hrBatch;

    protected void start() throws IllegalAccessException {
        super.start();
        this.total = 0;
        this.hrBatch = (HrBatch)((Object)((HrBatchRepository)((Object)Beans.get(HrBatchRepository.class))).find(this.batch.getHrBatch().getId()));
        this.checkPoint();
    }

    protected void process() {
        List employmentContractList = ((EmploymentContractRepository)((Object)Beans.get(EmploymentContractRepository.class))).all().filter("self.payCompany = ?1 AND self.status = ?2", new Object[]{this.hrBatch.getCompany(), 2}).fetch();
        switch (this.hrBatch.getEmploymentContractExportTypeSelect()) {
            case 1: {
                try {
                    this.batch.setMetaFile(this.employmentContractExportSilae(employmentContractList));
                }
                catch (IOException e) {
                    this.incrementAnomaly();
                    TraceBackService.trace((Throwable)e);
                }
                break;
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public MetaFile employmentContractExportSilae(List<EmploymentContract> employmentContractList) throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (EmploymentContract employmentContract : employmentContractList) {
            ((EmploymentContractService)Beans.get(EmploymentContractService.class)).employmentContractExportSilae(employmentContract, list);
            ++this.total;
            this.incrementDone();
        }
        File tempFile = MetaFiles.createTempFile((String)((EmploymentContractService)Beans.get(EmploymentContractService.class)).employmentContractExportName(), (String)".csv", (FileAttribute[])new FileAttribute[0]).toFile();
        String[] headers = ((EmploymentContractService)Beans.get(EmploymentContractService.class)).employmentContractExportHeaders();
        CsvTool.csvWriter((String)tempFile.getParent(), (String)tempFile.getName(), (char)';', (String[])headers, list);
        MetaFiles metaFiles = (MetaFiles)Beans.get(MetaFiles.class);
        MetaFile metaFile = metaFiles.upload(tempFile);
        tempFile.delete();
        return metaFile;
    }

    protected void stop() {
        String comment = String.format(I18n.get((String)"Employment contracts exported : %s") + '\n', this.total);
        this.addComment(comment);
        super.stop();
    }
}

