/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.HrBatch;
import com.axelor.apps.hr.db.PayrollPreparation;
import com.axelor.apps.hr.db.repo.HrBatchRepository;
import com.axelor.apps.hr.db.repo.PayrollPreparationRepository;
import com.axelor.apps.hr.service.PayrollPreparationService;
import com.axelor.apps.hr.service.batch.BatchStrategy;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class BatchPayrollPreparationExport
extends BatchStrategy {
    protected int total;
    protected HrBatch hrBatch;
    protected PayrollPreparationService payrollPreparationService;
    @Inject
    protected PayrollPreparationRepository payrollPreparationRepository;
    @Inject
    CompanyRepository companyRepository;
    @Inject
    PeriodRepository periodRepository;
    @Inject
    HRConfigService hrConfigService;

    @Inject
    public BatchPayrollPreparationExport(PayrollPreparationService payrollPreparationService) {
        this.payrollPreparationService = payrollPreparationService;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        this.total = 0;
        this.hrBatch = (HrBatch)((Object)((HrBatchRepository)((Object)Beans.get(HrBatchRepository.class))).find(this.batch.getHrBatch().getId()));
        this.checkPoint();
    }

    protected void process() {
        String exportAll = "";
        if (!this.hrBatch.getExportAlreadyExported().booleanValue()) {
            exportAll = " AND self.exported = false ";
        }
        List payrollPreparationList = this.payrollPreparationRepository.all().filter("self.company = ?1 AND self.period = ?2 " + exportAll, new Object[]{this.hrBatch.getCompany(), this.hrBatch.getPeriod()}).fetch();
        switch (this.hrBatch.getPayrollPreparationExportTypeSelect()) {
            case 1: {
                try {
                    this.batch.setMetaFile(this.standardExport(payrollPreparationList));
                }
                catch (IOException e) {
                    this.incrementAnomaly();
                    TraceBackService.trace((Throwable)e, (String)"leaveManagement", (long)this.batch.getId());
                }
                break;
            }
            case 2: {
                try {
                    this.batch.setMetaFile(this.nibelisExport(payrollPreparationList));
                }
                catch (Exception e) {
                    this.incrementAnomaly();
                    TraceBackService.trace((Throwable)e, (String)"leaveManagement", (long)this.batch.getId());
                }
                break;
            }
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public MetaFile standardExport(List<PayrollPreparation> payrollPreparationList) throws IOException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        LocalDate today = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(this.hrBatch.getCompany());
        for (PayrollPreparation payrollPreparation : payrollPreparationList) {
            String[] item = new String[]{payrollPreparation.getEmployee().getName(), payrollPreparation.getDuration().toString(), payrollPreparation.getLunchVoucherNumber().toString(), payrollPreparation.getEmployeeBonusAmount().toString(), payrollPreparation.getExtraHoursNumber().toString()};
            list.add(item);
            payrollPreparation.setExported(true);
            payrollPreparation.setExportDate(today);
            payrollPreparation.setExportTypeSelect(1);
            payrollPreparation.addBatchListItem(this.batch);
            this.payrollPreparationRepository.save((Model)((Object)payrollPreparation));
            ++this.total;
            this.incrementDone();
        }
        String fileName = ((PayrollPreparationService)Beans.get(PayrollPreparationService.class)).getPayrollPreparationExportName();
        String filePath = AppSettings.get().get("file.upload.dir");
        MetaFile metaFile = new MetaFile();
        metaFile.setFileName(fileName);
        metaFile.setFilePath(fileName);
        metaFile = (MetaFile)((MetaFileRepository)Beans.get(MetaFileRepository.class)).save((Model)metaFile);
        new File(filePath).mkdirs();
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)';', (String[])((PayrollPreparationService)Beans.get(PayrollPreparationService.class)).getPayrollPreparationExportHeader(), list);
        return metaFile;
    }

    @Transactional(rollbackOn={Exception.class})
    public MetaFile nibelisExport(List<PayrollPreparation> payrollPreparationList) throws IOException, AxelorException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (PayrollPreparation payrollPreparation : payrollPreparationList) {
            payrollPreparation.addBatchListItem(this.batch);
            this.payrollPreparationService.exportNibelis(payrollPreparation, list);
            ++this.total;
        }
        String fileName = ((PayrollPreparationService)Beans.get(PayrollPreparationService.class)).getPayrollPreparationExportName();
        String filePath = AppSettings.get().get("file.upload.dir");
        MetaFile metaFile = new MetaFile();
        metaFile.setFileName(fileName);
        metaFile.setFilePath(fileName);
        metaFile = (MetaFile)((MetaFileRepository)Beans.get(MetaFileRepository.class)).save((Model)metaFile);
        new File(filePath).mkdirs();
        CsvTool.csvWriter((String)filePath, (String)fileName, (char)';', (String[])((PayrollPreparationService)Beans.get(PayrollPreparationService.class)).getPayrollPreparationMeilleurGestionExportHeader(), list);
        return metaFile;
    }

    protected void stop() {
        String comment = String.format(I18n.get((String)"Payroll preparations exported : %s") + '\n', this.total);
        this.addComment(comment);
        super.stop();
    }
}

