/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.hr.service.batch.BatchStrategy;
import com.axelor.apps.hr.service.leave.management.LeaveManagementService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.meta.db.MetaModel;
import com.google.inject.Inject;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;

public class BatchTimesheetReminder
extends BatchStrategy {
    protected TimesheetRepository timesheetRepo;
    protected MessageService messageService;
    protected MessageRepository messageRepo;
    protected TemplateMessageService templateMessageService;

    @Inject
    public BatchTimesheetReminder(LeaveManagementService leaveManagementService, TimesheetRepository timesheetRepo, MessageService messageService, MessageRepository messageRepo, TemplateMessageService templateMessageService) {
        super(leaveManagementService);
        this.timesheetRepo = timesheetRepo;
        this.messageService = messageService;
        this.messageRepo = messageRepo;
        this.templateMessageService = templateMessageService;
    }

    protected void process() {
        Template template = this.batch.getHrBatch().getTemplate();
        MetaModel metaModel = template.getMetaModel();
        try {
            if (metaModel != null) {
                if (metaModel.getName().equals(Employee.class.getSimpleName())) {
                    this.sendReminderUsingEmployees(template);
                } else if (metaModel.getName().equals(Timesheet.class.getSimpleName())) {
                    this.sendReminderUsingTimesheets(template);
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e, (String)metaModel.getName(), (long)this.batch.getId());
            this.incrementAnomaly();
        }
    }

    protected void stop() {
        String comment = String.format(I18n.get((String)"Employees computed: %d"), this.batch.getDone()) + "<br/>" + String.format(I18n.get((String)"Employees failed to be computed due to anomaly: %d"), this.batch.getAnomaly());
        this.addComment(comment);
        super.stop();
    }

    private List<Employee> getEmployeesWithoutRecentTimesheet(Company company) {
        LocalDate now = this.appBaseService.getTodayDate(company);
        long daysBeforeReminder = this.batch.getHrBatch().getDaysBeforeReminder();
        List employees = this.employeeRepository.all().filter("self.timesheetReminder = 't' AND self.mainEmploymentContract.payCompany = :companyId").bind("companyId", (Object)this.batch.getHrBatch().getCompany().getId()).fetch();
        employees.removeIf(employee -> this.hasRecentTimesheet(now, daysBeforeReminder, (Employee)((Object)employee)));
        return employees;
    }

    private boolean hasRecentTimesheet(LocalDate now, long daysBeforeReminder, Employee employee) {
        Timesheet timesheet = this.getRecentEmployeeTimesheet(employee);
        return timesheet != null && timesheet.getToDate().plusDays(daysBeforeReminder).isAfter(now);
    }

    protected Timesheet getRecentEmployeeTimesheet(Employee employee) {
        Timesheet timesheet = (Timesheet)((Object)this.timesheetRepo.all().filter("self.user.id = :userId AND self.statusSelect IN (:confirmed, :validated) AND self.company = :companyId").bind("userId", (Object)employee.getUser().getId()).bind("confirmed", (Object)2).bind("validated", (Object)3).bind("companyId", (Object)this.batch.getHrBatch().getCompany().getId()).order("-toDate").fetchOne());
        return timesheet;
    }

    protected void sendReminderUsingEmployees(Template template) throws AxelorException, MessagingException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (Employee employee : this.getEmployeesWithoutRecentTimesheet(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null))) {
            Message message = this.templateMessageService.generateMessage((Model)((Object)employee), template);
            this.messageService.sendByEmail(message);
            this.incrementDone();
        }
    }

    protected void sendReminderUsingTimesheets(Template template) throws AxelorException, MessagingException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        for (Employee employee : this.getEmployeesWithoutRecentTimesheet(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null))) {
            Timesheet timeSheet = this.getRecentEmployeeTimesheet(employee);
            if (timeSheet == null) {
                throw new AxelorException(Timesheet.class, 3, I18n.get((String)"No time sheet found for employee %s"), new Object[]{employee.getName()});
            }
            Message message = this.templateMessageService.generateMessage((Model)((Object)timeSheet), template);
            this.messageService.sendByEmail(message);
            this.incrementDone();
        }
    }
}

