/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.batch;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.Timesheet;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.TimesheetRepository;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.db.repo.EmailAccountRepository;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.mail.MessagingException;

public class BatchTimesheetValidationReminder
extends AbstractBatch {
    protected TemplateMessageService templateMessageService;
    protected MessageService messageService;
    protected MessageRepository messageRepo;

    @Inject
    public BatchTimesheetValidationReminder(TemplateMessageService templateMessageService, MessageService messageService, MessageRepository messageRepo) {
        this.templateMessageService = templateMessageService;
        this.messageService = messageService;
        this.messageRepo = messageRepo;
    }

    protected void process() {
        Template template = this.batch.getMailBatch().getTemplate();
        switch (this.batch.getMailBatch().getCode()) {
            case "M_TS_REM": {
                if (template != null) {
                    this.generateEmailTemplate();
                    break;
                }
                this.generateEmail();
                break;
            }
            case "M_A_TS_REM": {
                if (template != null) {
                    this.generateAllEmailTemplate();
                    break;
                }
                this.generateAllEmail();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void generateEmailTemplate() {
        Company company = this.batch.getMailBatch().getCompany();
        Template template = this.batch.getMailBatch().getTemplate();
        List timesheetList = null;
        timesheetList = ((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).all().count() > 1L ? ((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).all().filter("self.company.id = ?1 AND self.statusSelect = 1 AND self.user.employee.timesheetReminder = true", new Object[]{company.getId()}).fetch() : ((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).all().filter("self.statusSelect = 1 AND self.user.employee.timesheetReminder = true").fetch();
        String model = template.getMetaModel().getFullName();
        String tag = template.getMetaModel().getName();
        for (Timesheet timesheet : timesheetList) {
            try {
                Message message = this.templateMessageService.generateMessage(timesheet.getUser().getEmployee().getId(), model, tag, template);
                this.messageService.sendByEmail(message);
                this.incrementDone();
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)new Exception(e), (String)"reminder", (long)this.batch.getId());
            }
        }
    }

    public void generateEmail() {
        List timesheetList = ((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).all().count() > 1L ? ((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).all().filter("self.company.id = ?1 AND self.statusSelect = 1 AND self.user.employee.timesheetReminder = true", new Object[]{this.batch.getMailBatch().getCompany().getId()}).fetch() : ((TimesheetRepository)((Object)Beans.get(TimesheetRepository.class))).all().filter("self.statusSelect = 1 AND self.user.employee.timesheetReminder = true").fetch();
        for (Timesheet timesheet : timesheetList) {
            try {
                this.generateAndSendMessage(timesheet.getUser().getEmployee());
                this.incrementDone();
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)new Exception(e), (String)"invoice", (long)this.batch.getId());
            }
        }
    }

    public void generateAllEmailTemplate() {
        Template template = this.batch.getMailBatch().getTemplate();
        String model = template.getMetaModel().getFullName();
        String tag = template.getMetaModel().getName();
        List employeeList = ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).all().filter("self.timesheetReminder = true").fetch();
        for (Employee employee : employeeList) {
            try {
                Message message = this.templateMessageService.generateMessage(employee.getId(), model, tag, template);
                this.messageService.sendByEmail(message);
                this.incrementDone();
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)new Exception(e), (String)"reminder", (long)this.batch.getId());
            }
        }
    }

    public void generateAllEmail() {
        List employeeList = ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).all().filter("self.timesheetReminder = true").fetch();
        for (Employee employee : employeeList) {
            try {
                this.generateAndSendMessage(employee);
                this.incrementDone();
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)new Exception(e), (String)"invoice", (long)this.batch.getId());
            }
        }
    }

    @Transactional(rollbackOn={MessagingException.class, IOException.class, Exception.class})
    protected Message generateAndSendMessage(Employee employee) throws MessagingException, IOException, AxelorException {
        Message message = new Message();
        message.setMediaTypeSelect(2);
        message.setReplyToEmailAddressSet(new HashSet<EmailAddress>());
        message.setCcEmailAddressSet(new HashSet<EmailAddress>());
        message.setBccEmailAddressSet(new HashSet<EmailAddress>());
        message.addToEmailAddressSetItem(employee.getContactPartner().getEmailAddress());
        message.setSenderUser(AuthUtils.getUser());
        message.setSubject(this.batch.getMailBatch().getSubject());
        message.setContent(this.batch.getMailBatch().getContent());
        message.setMailAccount((EmailAccount)((Object)((EmailAccountRepository)((Object)Beans.get(EmailAccountRepository.class))).all().filter("self.isDefault = true").fetchOne()));
        message = (Message)((Object)this.messageRepo.save((Model)((Object)message)));
        return this.messageService.sendByEmail(message);
    }

    protected void stop() {
        String comment = String.format("\t* %s Email(s) sent %n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

