/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.employee;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.EventsPlanning;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserServiceImpl;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.hr.db.DPAE;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContract;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.hr.db.repo.LeaveRequestRepository;
import com.axelor.apps.hr.service.employee.EmployeeService;
import com.axelor.apps.hr.service.leave.LeaveService;
import com.axelor.apps.hr.service.publicHoliday.PublicHolidayHrService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Period;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmployeeServiceImpl
extends UserServiceImpl
implements EmployeeService {
    @Inject
    protected WeeklyPlanningService weeklyPlanningService;

    @Override
    public int getLengthOfService(Employee employee, LocalDate refDate) throws AxelorException {
        try {
            Period period = Period.between(employee.getSeniorityDate(), refDate == null ? ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(employee.getUser() != null ? employee.getUser().getActiveCompany() : null) : refDate);
            return period.getYears();
        }
        catch (IllegalArgumentException e) {
            throw new AxelorException(e.getCause(), (Model)((Object)employee), 3, I18n.get((String)"The employee %s has no seniority date"), new Object[]{employee.getName()});
        }
    }

    @Override
    public int getAge(Employee employee, LocalDate refDate) throws AxelorException {
        try {
            Period period = Period.between(employee.getBirthDate(), refDate == null ? ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(employee.getUser() != null ? employee.getUser().getActiveCompany() : null) : refDate);
            return period.getYears();
        }
        catch (IllegalArgumentException e) {
            throw new AxelorException(e.getCause(), (Model)((Object)employee), 3, I18n.get((String)"The employee %s has no birth date"), new Object[]{employee.getName()});
        }
    }

    @Override
    public BigDecimal getDaysWorksInPeriod(Employee employee, LocalDate fromDate, LocalDate toDate) throws AxelorException {
        HRConfig conf;
        HRConfig conf2;
        Company company = employee.getMainEmploymentContract().getPayCompany();
        BigDecimal duration = BigDecimal.ZERO;
        WeeklyPlanning weeklyPlanning = employee.getWeeklyPlanning();
        if (weeklyPlanning == null && (conf2 = company.getHrConfig()) != null) {
            weeklyPlanning = conf2.getWeeklyPlanning();
        }
        if (weeklyPlanning == null) {
            throw new AxelorException((Model)((Object)employee), 4, I18n.get((String)"Please, add a planning for employee : %s"), new Object[]{employee.getName()});
        }
        EventsPlanning publicHolidayPlanning = employee.getPublicHolidayEventsPlanning();
        if (publicHolidayPlanning == null && (conf = company.getHrConfig()) != null) {
            publicHolidayPlanning = conf.getPublicHolidayEventsPlanning();
        }
        if (publicHolidayPlanning == null) {
            throw new AxelorException((Model)((Object)employee), 4, I18n.get((String)"Please, add a public holiday planning for employee : %s"), new Object[]{employee.getName()});
        }
        LocalDate date = fromDate;
        while (!date.isAfter(toDate)) {
            duration = duration.add(BigDecimal.valueOf(this.weeklyPlanningService.getWorkingDayValueInDays(weeklyPlanning, date)));
            date = date.plusDays(1L);
        }
        duration = duration.subtract(((PublicHolidayHrService)((Object)Beans.get(PublicHolidayHrService.class))).computePublicHolidayDays(fromDate, toDate, weeklyPlanning, publicHolidayPlanning));
        return duration;
    }

    @Override
    public BigDecimal getDaysWorkedInPeriod(Employee employee, LocalDate fromDate, LocalDate toDate) throws AxelorException {
        BigDecimal daysWorks = this.getDaysWorksInPeriod(employee, fromDate, toDate);
        BigDecimal daysLeave = BigDecimal.ZERO;
        List leaveRequestList = ((LeaveRequestRepository)((Object)Beans.get(LeaveRequestRepository.class))).all().filter("self.user = ?1 AND self.duration >= 1 AND self.statusSelect = ?2 AND (self.fromDateT BETWEEN ?3 AND ?4 OR self.toDateT BETWEEN ?3 AND ?4 OR ?3 BETWEEN self.fromDateT AND self.toDateT OR ?4 BETWEEN self.fromDateT AND self.toDateT)", new Object[]{employee.getUser(), 3, fromDate, toDate}).fetch();
        for (LeaveRequest leaveRequest : leaveRequestList) {
            daysLeave = daysLeave.add(((LeaveService)Beans.get(LeaveService.class)).computeDuration(leaveRequest, fromDate, toDate));
        }
        return daysWorks.subtract(daysLeave);
    }

    @Override
    public Map<String, String> getSocialNetworkUrl(String name, String firstName) {
        HashMap<String, String> urlMap = new HashMap<String, String>();
        name = firstName != null && name != null ? firstName + "+" + name : (name == null ? firstName : name);
        name = name == null ? "" : name;
        urlMap.put("facebook", "<a class='fa fa-facebook' href='https://www.facebook.com/search/more/?q=" + name + "&init=public' target='_blank'/>");
        urlMap.put("twitter", "<a class='fa fa-twitter' href='https://twitter.com/search?q=" + name + "' target='_blank' />");
        urlMap.put("linkedin", "<a class='fa fa-linkedin' href='http://www.linkedin.com/pub/dir/" + name.replace("+", "/") + "' target='_blank' />");
        urlMap.put("youtube", "<a class='fa fa-youtube' href='https://www.youtube.com/results?search_query=" + name + "' target='_blank' />");
        return urlMap;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Long generateNewDPAE(Employee employee) throws AxelorException {
        EmploymentContract mainEmploymentContract = employee.getMainEmploymentContract();
        if (mainEmploymentContract == null) {
            throw new AxelorException(1, I18n.get((String)"Please, add a contract of employment for employee : %s"), new Object[]{employee.getName()});
        }
        Company payCompany = mainEmploymentContract.getPayCompany();
        Partner employer = payCompany.getPartner();
        DPAE newDPAE = new DPAE();
        newDPAE.setRegistrationCode(employer.getRegistrationCode());
        newDPAE.setMainActivityCode(employer.getMainActivityCode());
        newDPAE.setCompany(payCompany);
        newDPAE.setCompanyAddress(employer.getMainAddress());
        newDPAE.setCompanyFixedPhone(employer.getFixedPhone());
        if (payCompany.getHrConfig() != null) {
            newDPAE.setHealthService(payCompany.getHrConfig().getHealthService());
            newDPAE.setHealthServiceAddress(payCompany.getHrConfig().getHealthServiceAddress());
        }
        newDPAE.setLastName(employee.getContactPartner().getName());
        newDPAE.setFirstName(employee.getContactPartner().getFirstName());
        newDPAE.setSocialSecurityNumber(employee.getSocialSecurityNumber());
        newDPAE.setSexSelect(employee.getSexSelect());
        newDPAE.setBirthDate(employee.getBirthDate());
        newDPAE.setDepartmentOfBirth(employee.getDepartmentOfBirth());
        newDPAE.setCityOfBirth(employee.getCityOfBirth());
        newDPAE.setCountryOfBirth(employee.getCountryOfBirth());
        newDPAE.setHireDate(mainEmploymentContract.getStartDate());
        newDPAE.setHireTime(mainEmploymentContract.getStartTime());
        newDPAE.setTrialPeriodDuration(mainEmploymentContract.getTrialPeriodDuration());
        newDPAE.setContractType(mainEmploymentContract.getContractType());
        newDPAE.setContractEndDate(mainEmploymentContract.getEndDate());
        employee.addDpaeListItem(newDPAE);
        ((EmployeeRepository)((Object)Beans.get(EmployeeRepository.class))).save((Model)((Object)employee));
        return newDPAE.getId();
    }
}

