/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.expense;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.AnalyticMoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.generator.InvoiceLineGenerator;
import com.axelor.apps.account.service.move.MoveCancelService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmployeeAdvanceUsage;
import com.axelor.apps.hr.db.EmployeeVehicle;
import com.axelor.apps.hr.db.Expense;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.KilometricAllowParam;
import com.axelor.apps.hr.db.repo.ExpenseLineRepository;
import com.axelor.apps.hr.db.repo.ExpenseRepository;
import com.axelor.apps.hr.service.EmployeeAdvanceService;
import com.axelor.apps.hr.service.KilometricService;
import com.axelor.apps.hr.service.bankorder.BankOrderCreateServiceHr;
import com.axelor.apps.hr.service.config.AccountConfigHRService;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.expense.ExpenseService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.commons.collections.CollectionUtils;

@Singleton
public class ExpenseServiceImpl
implements ExpenseService {
    protected MoveService moveService;
    protected ExpenseRepository expenseRepository;
    protected MoveLineService moveLineService;
    protected AccountManagementAccountService accountManagementService;
    protected AppAccountService appAccountService;
    protected AccountConfigHRService accountConfigService;
    protected AccountingSituationService accountingSituationService;
    protected AnalyticMoveLineService analyticMoveLineService;
    protected HRConfigService hrConfigService;
    protected TemplateMessageService templateMessageService;
    protected PaymentModeService paymentModeService;

    @Inject
    public ExpenseServiceImpl(MoveService moveService, ExpenseRepository expenseRepository, MoveLineService moveLineService, AccountManagementAccountService accountManagementService, AppAccountService appAccountService, AccountConfigHRService accountConfigService, AccountingSituationService accountingSituationService, AnalyticMoveLineService analyticMoveLineService, HRConfigService hrConfigService, TemplateMessageService templateMessageService, PaymentModeService paymentModeService) {
        this.moveService = moveService;
        this.expenseRepository = expenseRepository;
        this.moveLineService = moveLineService;
        this.accountManagementService = accountManagementService;
        this.appAccountService = appAccountService;
        this.accountConfigService = accountConfigService;
        this.accountingSituationService = accountingSituationService;
        this.analyticMoveLineService = analyticMoveLineService;
        this.hrConfigService = hrConfigService;
        this.templateMessageService = templateMessageService;
        this.paymentModeService = paymentModeService;
    }

    @Override
    public ExpenseLine getAndComputeAnalyticDistribution(ExpenseLine expenseLine, Expense expense) {
        if (this.appAccountService.getAppAccount().getAnalyticDistributionTypeSelect() == 1) {
            return expenseLine;
        }
        AnalyticDistributionTemplate analyticDistributionTemplate = this.analyticMoveLineService.getAnalyticDistributionTemplate(expenseLine.getUser().getPartner(), expenseLine.getExpenseProduct(), expense.getCompany());
        expenseLine.setAnalyticDistributionTemplate(analyticDistributionTemplate);
        if (expenseLine.getAnalyticMoveLineList() != null) {
            expenseLine.getAnalyticMoveLineList().clear();
        }
        this.computeAnalyticDistribution(expenseLine);
        return expenseLine;
    }

    @Override
    public ExpenseLine computeAnalyticDistribution(ExpenseLine expenseLine) {
        List<AnalyticMoveLine> analyticMoveLineList = expenseLine.getAnalyticMoveLineList();
        if (analyticMoveLineList == null || analyticMoveLineList.isEmpty()) {
            this.createAnalyticDistributionWithTemplate(expenseLine);
        }
        if (analyticMoveLineList != null) {
            LocalDate date = this.appAccountService.getTodayDate(expenseLine.getExpense() != null ? expenseLine.getExpense().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
            for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
                this.analyticMoveLineService.updateAnalyticMoveLine(analyticMoveLine, expenseLine.getUntaxedAmount(), date);
            }
        }
        return expenseLine;
    }

    @Override
    public ExpenseLine createAnalyticDistributionWithTemplate(ExpenseLine expenseLine) {
        List analyticMoveLineList = this.analyticMoveLineService.generateLines(expenseLine.getAnalyticDistributionTemplate(), expenseLine.getUntaxedAmount(), 2, this.appAccountService.getTodayDate(expenseLine.getExpense() != null ? expenseLine.getExpense().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
        expenseLine.setAnalyticMoveLineList(analyticMoveLineList);
        return expenseLine;
    }

    @Override
    public Expense compute(Expense expense) {
        BigDecimal exTaxTotal = BigDecimal.ZERO;
        BigDecimal taxTotal = BigDecimal.ZERO;
        BigDecimal inTaxTotal = BigDecimal.ZERO;
        List<ExpenseLine> generalExpenseLineList = expense.getGeneralExpenseLineList();
        List<ExpenseLine> kilometricExpenseLineList = expense.getKilometricExpenseLineList();
        if (generalExpenseLineList != null) {
            for (ExpenseLine expenseLine : generalExpenseLineList) {
                exTaxTotal = exTaxTotal.add(expenseLine.getUntaxedAmount());
                taxTotal = taxTotal.add(expenseLine.getTotalTax());
                inTaxTotal = inTaxTotal.add(expenseLine.getTotalAmount());
            }
        }
        if (kilometricExpenseLineList != null) {
            for (ExpenseLine kilometricExpenseLine : kilometricExpenseLineList) {
                if (kilometricExpenseLine.getUntaxedAmount() != null) {
                    exTaxTotal = exTaxTotal.add(kilometricExpenseLine.getUntaxedAmount());
                }
                if (kilometricExpenseLine.getTotalTax() != null) {
                    taxTotal = taxTotal.add(kilometricExpenseLine.getTotalTax());
                }
                if (kilometricExpenseLine.getTotalAmount() == null) continue;
                inTaxTotal = inTaxTotal.add(kilometricExpenseLine.getTotalAmount());
            }
        }
        expense.setExTaxTotal(exTaxTotal);
        expense.setTaxTotal(taxTotal);
        expense.setInTaxTotal(inTaxTotal);
        return expense;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void confirm(Expense expense) throws AxelorException {
        expense.setStatusSelect(2);
        expense.setSentDate(this.appAccountService.getTodayDate(expense.getCompany()));
        this.expenseRepository.save((Model)((Object)expense));
    }

    @Override
    public Message sendConfirmationEmail(Expense expense) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(expense.getCompany());
        if (hrConfig.getExpenseMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)expense), this.hrConfigService.getSentExpenseTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(Expense expense) throws AxelorException {
        Employee employee = expense.getUser().getEmployee();
        if (employee == null) {
            throw new AxelorException((Model)((Object)expense), 4, I18n.get((String)"Please create an employee for the user %s"), new Object[]{expense.getUser().getFullName()});
        }
        if (expense.getPeriod() == null) {
            throw new AxelorException((Model)((Object)expense), 1, I18n.get((String)"Please fill the period"));
        }
        List<ExpenseLine> kilometricExpenseLineList = expense.getKilometricExpenseLineList();
        KilometricService kilometricService = (KilometricService)Beans.get(KilometricService.class);
        if (ObjectUtils.notEmpty(kilometricExpenseLineList)) {
            for (ExpenseLine line : kilometricExpenseLineList) {
                BigDecimal amount = kilometricService.computeKilometricExpense(line, employee);
                line.setTotalAmount(amount);
                line.setUntaxedAmount(amount);
                kilometricService.updateKilometricLog(line, employee);
            }
            this.compute(expense);
        }
        ((EmployeeAdvanceService)Beans.get(EmployeeAdvanceService.class)).fillExpenseWithAdvances(expense);
        expense.setStatusSelect(3);
        expense.setValidatedBy(AuthUtils.getUser());
        expense.setValidationDate(this.appAccountService.getTodayDate(expense.getCompany()));
        if (expense.getUser().getPartner() != null) {
            PaymentMode paymentMode = expense.getUser().getPartner().getOutPaymentMode();
            expense.setPaymentMode(paymentMode);
        }
        this.expenseRepository.save((Model)((Object)expense));
    }

    @Override
    public Message sendValidationEmail(Expense expense) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(expense.getCompany());
        if (hrConfig.getExpenseMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)expense), this.hrConfigService.getValidatedExpenseTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void refuse(Expense expense) throws AxelorException {
        expense.setStatusSelect(5);
        expense.setRefusedBy(AuthUtils.getUser());
        expense.setRefusalDate(this.appAccountService.getTodayDate(expense.getCompany()));
        this.expenseRepository.save((Model)((Object)expense));
    }

    @Override
    public Message sendRefusalEmail(Expense expense) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(expense.getCompany());
        if (hrConfig.getExpenseMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)expense), this.hrConfigService.getRefusedExpenseTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Move ventilate(Expense expense) throws AxelorException {
        Move move = null;
        this.setExpenseSeq(expense);
        if (expense.getInTaxTotal().signum() != 0) {
            move = this.createAndSetMove(expense);
        }
        expense.setVentilated(true);
        this.expenseRepository.save((Model)((Object)expense));
        return move;
    }

    protected Move createAndSetMove(Expense expense) throws AxelorException {
        LocalDate moveDate = expense.getMoveDate();
        if (moveDate == null) {
            moveDate = this.appAccountService.getTodayDate(expense.getCompany());
            expense.setMoveDate(moveDate);
        }
        Company company = expense.getCompany();
        Partner partner = expense.getUser().getPartner();
        Account account = null;
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        if (partner == null) {
            throw new AxelorException((Model)((Object)expense), 4, I18n.get((String)"You must create a contact for user %s"), new Object[]{expense.getUser().getName()});
        }
        Move move = this.moveService.getMoveCreateService().createMove(this.accountConfigService.getExpenseJournal(accountConfig), company, null, partner, moveDate, partner.getInPaymentMode(), 2);
        ArrayList<MoveLine> moveLines = new ArrayList<MoveLine>();
        HashSet analyticAccounts = new HashSet();
        BigDecimal exTaxTotal = null;
        int moveLineId = 1;
        int expenseLineId = 1;
        Account employeeAccount = this.accountingSituationService.getEmployeeAccount(partner, company);
        moveLines.add(this.moveLineService.createMoveLine(move, partner, employeeAccount, expense.getInTaxTotal(), false, moveDate, moveDate, moveLineId++, expense.getExpenseSeq(), expense.getFullName()));
        for (ExpenseLine expenseLine : this.getExpenseLineList(expense)) {
            analyticAccounts.clear();
            Product product = expenseLine.getExpenseProduct();
            account = this.accountManagementService.getProductAccount(product, company, partner.getFiscalPosition(), true, false);
            if (account == null) {
                throw new AxelorException((Model)((Object)expense), 4, I18n.get((String)"Account missing on configuration for line : %s (company : %s)"), new Object[]{expenseLineId, company.getName()});
            }
            exTaxTotal = expenseLine.getUntaxedAmount();
            MoveLine moveLine = this.moveLineService.createMoveLine(move, partner, account, exTaxTotal, true, moveDate, moveDate, moveLineId++, expense.getExpenseSeq(), expenseLine.getComments() != null ? expenseLine.getComments().replaceAll("(\r\n|\n\r|\r|\n)", " ") : "");
            for (AnalyticMoveLine analyticDistributionLineIt : expenseLine.getAnalyticMoveLineList()) {
                AnalyticMoveLine analyticDistributionLine = (AnalyticMoveLine)((Object)((AnalyticMoveLineRepository)((Object)Beans.get(AnalyticMoveLineRepository.class))).copy((Model)((Object)analyticDistributionLineIt), false));
                analyticDistributionLine.setExpenseLine(null);
                moveLine.addAnalyticMoveLineListItem(analyticDistributionLine);
            }
            moveLines.add(moveLine);
            ++expenseLineId;
        }
        this.moveLineService.consolidateMoveLines(moveLines);
        account = this.accountConfigService.getExpenseTaxAccount(accountConfig);
        BigDecimal taxTotal = BigDecimal.ZERO;
        for (ExpenseLine expenseLine : this.getExpenseLineList(expense)) {
            exTaxTotal = expenseLine.getTotalTax();
            taxTotal = taxTotal.add(exTaxTotal);
        }
        if (taxTotal.signum() != 0) {
            MoveLine moveLine = this.moveLineService.createMoveLine(move, partner, account, taxTotal, true, moveDate, moveDate, moveLineId++, expense.getExpenseSeq(), expense.getFullName());
            moveLines.add(moveLine);
        }
        move.getMoveLineList().addAll(moveLines);
        this.moveService.getMoveValidateService().validate(move);
        expense.setMove(move);
        return move;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancel(Expense expense) throws AxelorException {
        Move move = expense.getMove();
        if (move == null) {
            expense.setStatusSelect(6);
            this.expenseRepository.save((Model)((Object)expense));
            return;
        }
        ((PeriodService)Beans.get(PeriodService.class)).testOpenPeriod(move.getPeriod());
        try {
            ((MoveRepository)Beans.get(MoveRepository.class)).remove((Model)move);
            expense.setMove(null);
            expense.setVentilated(false);
            expense.setStatusSelect(6);
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, (Model)((Object)expense), 4, I18n.get((String)"Move already used, you must unreconcile it first"));
        }
        this.expenseRepository.save((Model)((Object)expense));
    }

    @Override
    public Message sendCancellationEmail(Expense expense) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(expense.getCompany());
        if (hrConfig.getTimesheetMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)expense), this.hrConfigService.getCanceledExpenseTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void addPayment(Expense expense, BankDetails bankDetails) throws AxelorException {
        expense.setPaymentDate(this.appAccountService.getTodayDate(expense.getCompany()));
        PaymentMode paymentMode = expense.getPaymentMode();
        if (paymentMode == null) {
            paymentMode = expense.getUser().getPartner().getOutPaymentMode();
            if (paymentMode == null) {
                throw new AxelorException((Model)((Object)expense), 1, I18n.get((String)"Please fill the payment mode."));
            }
            expense.setPaymentMode(paymentMode);
        }
        if (paymentMode.getGenerateBankOrder().booleanValue()) {
            BankOrder bankOrder = ((BankOrderCreateServiceHr)((Object)Beans.get(BankOrderCreateServiceHr.class))).createBankOrder(expense, bankDetails);
            expense.setBankOrder(bankOrder);
            ((BankOrderRepository)Beans.get(BankOrderRepository.class)).save((Model)bankOrder);
            expense.setPaymentStatusSelect(3);
        } else {
            if (this.accountConfigService.getAccountConfig(expense.getCompany()).getGenerateMoveForInvoicePayment().booleanValue()) {
                this.createMoveForExpensePayment(expense);
            }
            if (paymentMode.getAutomaticTransmission().booleanValue()) {
                expense.setPaymentStatusSelect(3);
            } else {
                expense.setPaymentStatusSelect(1);
                expense.setStatusSelect(4);
            }
        }
        expense.setPaymentAmount(expense.getInTaxTotal().subtract(expense.getAdvanceAmount()).subtract(expense.getWithdrawnCash()).subtract(expense.getPersonalExpenseAmount()));
    }

    @Override
    public Move createMoveForExpensePayment(Expense expense) throws AxelorException {
        Company company = expense.getCompany();
        PaymentMode paymentMode = expense.getPaymentMode();
        Partner partner = expense.getUser().getPartner();
        LocalDate paymentDate = expense.getPaymentDate();
        BigDecimal paymentAmount = expense.getInTaxTotal();
        BankDetails companyBankDetails = company.getDefaultBankDetails();
        Journal journal = this.paymentModeService.getPaymentModeJournal(paymentMode, company, companyBankDetails);
        MoveLine expenseMoveLine = this.getExpenseEmployeeMoveLineByLoop(expense);
        if (expenseMoveLine == null) {
            return null;
        }
        Account employeeAccount = expenseMoveLine.getAccount();
        Move move = this.moveService.getMoveCreateService().createMove(journal, company, expense.getMove().getCurrency(), partner, paymentDate, paymentMode, 2);
        move.addMoveLineListItem(this.moveLineService.createMoveLine(move, partner, this.paymentModeService.getPaymentModeAccount(paymentMode, company, companyBankDetails), paymentAmount, false, paymentDate, null, 1, expense.getExpenseSeq(), null));
        MoveLine employeeMoveLine = this.moveLineService.createMoveLine(move, partner, employeeAccount, paymentAmount, true, paymentDate, null, 2, expense.getExpenseSeq(), null);
        employeeMoveLine.setTaxAmount(expense.getTaxTotal());
        move.addMoveLineListItem(employeeMoveLine);
        this.moveService.getMoveValidateService().validate(move);
        expense.setPaymentMove(move);
        ((ReconcileService)Beans.get(ReconcileService.class)).reconcile(expenseMoveLine, employeeMoveLine, true, false);
        this.expenseRepository.save((Model)((Object)expense));
        return move;
    }

    protected MoveLine getExpenseEmployeeMoveLineByLoop(Expense expense) {
        MoveLine expenseEmployeeMoveLine = null;
        for (MoveLine moveline : expense.getMove().getMoveLineList()) {
            if (moveline.getCredit().compareTo(BigDecimal.ZERO) <= 0) continue;
            expenseEmployeeMoveLine = moveline;
        }
        return expenseEmployeeMoveLine;
    }

    @Override
    public void addPayment(Expense expense) throws AxelorException {
        this.addPayment(expense, expense.getCompany().getDefaultBankDetails());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancelPayment(Expense expense) throws AxelorException {
        Move paymentMove;
        BankOrder bankOrder = expense.getBankOrder();
        if (bankOrder != null) {
            if (bankOrder.getStatusSelect() == 4 || bankOrder.getStatusSelect() == 5) {
                throw new AxelorException(5, I18n.get((String)"The bank order linked to this expense has already been carried out/rejected, and thus can't be canceled"));
            }
            if (bankOrder.getStatusSelect() != 6) {
                ((BankOrderService)Beans.get(BankOrderService.class)).cancelBankOrder(bankOrder);
            }
        }
        if ((paymentMove = expense.getPaymentMove()) != null) {
            expense.setPaymentMove(null);
            ((MoveCancelService)Beans.get(MoveCancelService.class)).cancel(paymentMove);
        }
        expense.setPaymentStatusSelect(2);
        expense.setStatusSelect(3);
        expense.setPaymentDate(null);
        expense.setPaymentAmount(BigDecimal.ZERO);
        this.expenseRepository.save((Model)((Object)expense));
    }

    @Override
    public List<InvoiceLine> createInvoiceLines(Invoice invoice, List<ExpenseLine> expenseLineList, int priority) throws AxelorException {
        ArrayList<InvoiceLine> invoiceLineList = new ArrayList<InvoiceLine>();
        int count = 0;
        for (ExpenseLine expenseLine : expenseLineList) {
            invoiceLineList.addAll(this.createInvoiceLine(invoice, expenseLine, priority * 100 + count));
            ++count;
            expenseLine.setInvoiced(true);
        }
        return invoiceLineList;
    }

    @Override
    public List<InvoiceLine> createInvoiceLine(Invoice invoice, ExpenseLine expenseLine, int priority) throws AxelorException {
        Product product = expenseLine.getExpenseProduct();
        InvoiceLineGenerator invoiceLineGenerator = null;
        Integer atiChoice = invoice.getCompany().getAccountConfig().getInvoiceInAtiSelect();
        invoiceLineGenerator = atiChoice == 1 || atiChoice == 3 ? new InvoiceLineGenerator(invoice, product, product.getName(), expenseLine.getUntaxedAmount(), expenseLine.getTotalAmount(), expenseLine.getUntaxedAmount(), expenseLine.getComments(), BigDecimal.ONE, product.getUnit(), null, priority, BigDecimal.ZERO, 0, expenseLine.getUntaxedAmount(), expenseLine.getTotalAmount(), false){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        } : new InvoiceLineGenerator(invoice, product, product.getName(), expenseLine.getUntaxedAmount(), expenseLine.getTotalAmount(), expenseLine.getTotalAmount(), expenseLine.getComments(), BigDecimal.ONE, product.getUnit(), null, priority, BigDecimal.ZERO, 0, expenseLine.getUntaxedAmount(), expenseLine.getTotalAmount(), false){

            public List<InvoiceLine> creates() throws AxelorException {
                InvoiceLine invoiceLine = this.createInvoiceLine();
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.add(invoiceLine);
                return invoiceLines;
            }
        };
        return invoiceLineGenerator.creates();
    }

    @Override
    public Expense getOrCreateExpense(User user) {
        Expense expense = (Expense)((Object)((ExpenseRepository)((Object)Beans.get(ExpenseRepository.class))).all().filter("self.statusSelect = ?1 AND self.user.id = ?2", new Object[]{1, user.getId()}).order("-id").fetchOne());
        if (expense == null) {
            expense = new Expense();
            expense.setUser(user);
            Company company = null;
            company = user.getEmployee() != null && user.getEmployee().getMainEmploymentContract() != null ? user.getEmployee().getMainEmploymentContract().getPayCompany() : user.getActiveCompany();
            Period period = (Period)((Object)((PeriodRepository)((Object)Beans.get(PeriodRepository.class))).all().filter("self.fromDate <= ?1 AND self.toDate >= ?1 AND self.allowExpenseCreation = true AND self.year.company = ?2 AND self.year.typeSelect = ?3", new Object[]{((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company), company, 1}).fetchOne());
            expense.setCompany(company);
            expense.setPeriod(period);
            expense.setStatusSelect(1);
        }
        return expense;
    }

    @Override
    public BigDecimal computePersonalExpenseAmount(Expense expense) {
        BigDecimal personalExpenseAmount = new BigDecimal("0.00");
        for (ExpenseLine expenseLine : this.getExpenseLineList(expense)) {
            if (expenseLine.getExpenseProduct() == null || !expenseLine.getExpenseProduct().getPersonalExpense().booleanValue()) continue;
            personalExpenseAmount = personalExpenseAmount.add(expenseLine.getTotalAmount());
        }
        return personalExpenseAmount;
    }

    @Override
    public BigDecimal computeAdvanceAmount(Expense expense) {
        BigDecimal advanceAmount = new BigDecimal("0.00");
        if (expense.getEmployeeAdvanceUsageList() != null && !expense.getEmployeeAdvanceUsageList().isEmpty()) {
            for (EmployeeAdvanceUsage advanceLine : expense.getEmployeeAdvanceUsageList()) {
                advanceAmount = advanceAmount.add(advanceLine.getUsedAmount());
            }
        }
        return advanceAmount;
    }

    @Override
    public Product getKilometricExpenseProduct(Expense expense) throws AxelorException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(expense.getCompany());
        return this.hrConfigService.getKilometricExpenseProduct(hrConfig);
    }

    @Override
    public void setDraftSequence(Expense expense) throws AxelorException {
        if (expense.getId() != null && Strings.isNullOrEmpty((String)expense.getExpenseSeq())) {
            expense.setExpenseSeq(((SequenceService)Beans.get(SequenceService.class)).getDraftSequenceNumber((Model)((Object)expense)));
        }
    }

    private void setExpenseSeq(Expense expense) throws AxelorException {
        if (!((SequenceService)Beans.get(SequenceService.class)).isEmptyOrDraftSequenceNumber(expense.getExpenseSeq())) {
            return;
        }
        HRConfig hrConfig = this.hrConfigService.getHRConfig(expense.getCompany());
        Sequence sequence = this.hrConfigService.getExpenseSequence(hrConfig);
        if (sequence != null) {
            expense.setExpenseSeq(((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber(sequence, expense.getSentDate()));
            if (expense.getExpenseSeq() != null) {
                return;
            }
        }
        throw new AxelorException((Model)((Object)expense), 4, I18n.get((String)"Company %s does not have any expense's sequence"), new Object[]{expense.getCompany().getName()});
    }

    @Override
    public List<KilometricAllowParam> getListOfKilometricAllowParamVehicleFilter(ExpenseLine expenseLine) throws AxelorException {
        ArrayList<KilometricAllowParam> kilometricAllowParamList = new ArrayList<KilometricAllowParam>();
        Expense expense = expenseLine.getExpense();
        if (expense == null) {
            return kilometricAllowParamList;
        }
        if (expense.getId() != null) {
            expense = (Expense)((Object)this.expenseRepository.find(expense.getId()));
        }
        LocalDate expenseDate = expenseLine.getExpenseDate();
        if (expense.getUser() == null || expense.getUser().getEmployee() == null || expenseDate == null) {
            return kilometricAllowParamList;
        }
        List<EmployeeVehicle> vehicleList = expense.getUser().getEmployee().getEmployeeVehicleList();
        for (EmployeeVehicle vehicle : vehicleList) {
            LocalDate startDate = vehicle.getStartDate();
            LocalDate endDate = vehicle.getEndDate();
            if (startDate == null) {
                if (endDate != null && expenseDate.compareTo(endDate) > 0) continue;
                kilometricAllowParamList.add(vehicle.getKilometricAllowParam());
                continue;
            }
            if (endDate == null) {
                if (expenseDate.compareTo(startDate) < 0) continue;
                kilometricAllowParamList.add(vehicle.getKilometricAllowParam());
                continue;
            }
            if (expenseDate.compareTo(startDate) < 0 || expenseDate.compareTo(endDate) > 0) continue;
            kilometricAllowParamList.add(vehicle.getKilometricAllowParam());
        }
        return kilometricAllowParamList;
    }

    @Override
    public List<KilometricAllowParam> getListOfKilometricAllowParamVehicleFilter(ExpenseLine expenseLine, Expense expense) throws AxelorException {
        ArrayList<KilometricAllowParam> kilometricAllowParamList = new ArrayList<KilometricAllowParam>();
        if (expense == null) {
            return kilometricAllowParamList;
        }
        if (expense.getId() != null) {
            expense = (Expense)((Object)this.expenseRepository.find(expense.getId()));
        }
        if (expense.getUser() != null && expense.getUser().getEmployee() == null) {
            return kilometricAllowParamList;
        }
        List<EmployeeVehicle> vehicleList = expense.getUser().getEmployee().getEmployeeVehicleList();
        LocalDate expenseDate = expenseLine.getExpenseDate();
        if (expenseDate == null) {
            throw new AxelorException(1, I18n.get((String)"There is no year selected for the allowance."));
        }
        for (EmployeeVehicle vehicle : vehicleList) {
            if (vehicle.getKilometricAllowParam() == null) break;
            LocalDate startDate = vehicle.getStartDate();
            LocalDate endDate = vehicle.getEndDate();
            if ((startDate != null || endDate != null && expenseDate.compareTo(endDate) > 0) && (endDate != null || expenseDate.compareTo(startDate) < 0 && (expenseDate.compareTo(startDate) < 0 || expenseDate.compareTo(endDate) > 0))) continue;
            kilometricAllowParamList.add(vehicle.getKilometricAllowParam());
        }
        return kilometricAllowParamList;
    }

    @Override
    public List<ExpenseLine> getExpenseLineList(Expense expense) {
        ArrayList<ExpenseLine> expenseLineList = new ArrayList<ExpenseLine>();
        if (expense.getGeneralExpenseLineList() != null) {
            expenseLineList.addAll(expense.getGeneralExpenseLineList());
        }
        if (expense.getKilometricExpenseLineList() != null) {
            expenseLineList.addAll(expense.getKilometricExpenseLineList());
        }
        return expenseLineList;
    }

    @Override
    public void completeExpenseLines(Expense expense) {
        ExpenseLineRepository expenseLineRepository = (ExpenseLineRepository)((Object)Beans.get(ExpenseLineRepository.class));
        List expenseLineList = expenseLineRepository.all().filter("self.expense.id = :_expenseId").bind("_expenseId", (Object)expense.getId()).fetch();
        List<ExpenseLine> kilometricExpenseLineList = expense.getKilometricExpenseLineList();
        List<ExpenseLine> generalExpenseLineList = expense.getGeneralExpenseLineList();
        for (ExpenseLine expenseLine : expenseLineList) {
            if (kilometricExpenseLineList.contains((Object)expenseLine) || generalExpenseLineList.contains((Object)expenseLine)) continue;
            expenseLine.setExpense(null);
            expenseLineRepository.remove((Model)((Object)expenseLine));
        }
        if (kilometricExpenseLineList != null) {
            for (ExpenseLine kilometricLine : kilometricExpenseLineList) {
                if (expenseLineList.contains((Object)kilometricLine)) continue;
                kilometricLine.setExpense(expense);
            }
        }
        if (generalExpenseLineList != null) {
            for (ExpenseLine generalExpenseLine : generalExpenseLineList) {
                if (expenseLineList.contains((Object)generalExpenseLine)) continue;
                generalExpenseLine.setExpense(expense);
            }
        }
    }

    @Override
    public Expense updateMoveDateAndPeriod(Expense expense) {
        if (CollectionUtils.isNotEmpty(expense.getGeneralExpenseLineList())) {
            LocalDate recentDate = expense.getGeneralExpenseLineList().stream().map(ExpenseLine::getExpenseDate).max(LocalDate::compareTo).get();
            expense.setMoveDate(recentDate);
            PeriodRepository periodRepository = (PeriodRepository)((Object)Beans.get(PeriodRepository.class));
            if (expense.getPeriod() == null || recentDate.compareTo(expense.getPeriod().getFromDate()) < 0 || recentDate.compareTo(expense.getPeriod().getToDate()) > 0) {
                expense.setPeriod((Period)((Object)periodRepository.all().filter("self.fromDate <= :_moveDate AND self.toDate >= :_moveDate AND self.statusSelect = 1 AND self.allowExpenseCreation = true AND self.year.company = :_company AND self.year.typeSelect = 1").bind("_moveDate", (Object)expense.getMoveDate()).bind("_company", (Object)expense.getCompany()).fetchOne()));
            }
        }
        return expense;
    }
}

