/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.extra.hours;

import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.ExtraHours;
import com.axelor.apps.hr.db.ExtraHoursLine;
import com.axelor.apps.hr.db.HRConfig;
import com.axelor.apps.hr.db.repo.ExtraHoursRepository;
import com.axelor.apps.hr.service.config.HRConfigService;
import com.axelor.apps.hr.service.extra.hours.ExtraHoursService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import javax.mail.MessagingException;

public class ExtraHoursServiceImpl
implements ExtraHoursService {
    protected ExtraHoursRepository extraHoursRepo;
    protected AppBaseService appBaseService;
    protected HRConfigService hrConfigService;
    protected TemplateMessageService templateMessageService;

    @Inject
    public ExtraHoursServiceImpl(ExtraHoursRepository extraHoursRepo, AppBaseService appBaseService, HRConfigService hrConfigService, TemplateMessageService templateMessageService) {
        this.extraHoursRepo = extraHoursRepo;
        this.appBaseService = appBaseService;
        this.hrConfigService = hrConfigService;
        this.templateMessageService = templateMessageService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancel(ExtraHours extraHours) throws AxelorException {
        extraHours.setStatusSelect(ExtraHoursRepository.STATUS_CANCELED);
        this.extraHoursRepo.save((Model)((Object)extraHours));
    }

    @Override
    public Message sendCancellationEmail(ExtraHours extraHours) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(extraHours.getCompany());
        if (hrConfig.getTimesheetMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)extraHours), this.hrConfigService.getCanceledExtraHoursTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void confirm(ExtraHours extraHours) throws AxelorException {
        extraHours.setStatusSelect(ExtraHoursRepository.STATUS_CONFIRMED);
        extraHours.setSentDate(this.appBaseService.getTodayDate(extraHours.getCompany()));
        this.extraHoursRepo.save((Model)((Object)extraHours));
    }

    @Override
    public Message sendConfirmationEmail(ExtraHours extraHours) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(extraHours.getCompany());
        if (hrConfig.getExtraHoursMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)extraHours), this.hrConfigService.getSentExtraHoursTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(ExtraHours extraHours) throws AxelorException {
        extraHours.setStatusSelect(ExtraHoursRepository.STATUS_VALIDATED);
        extraHours.setValidatedBy(AuthUtils.getUser());
        extraHours.setValidationDate(this.appBaseService.getTodayDate(extraHours.getCompany()));
        this.extraHoursRepo.save((Model)((Object)extraHours));
    }

    @Override
    public Message sendValidationEmail(ExtraHours extraHours) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(extraHours.getCompany());
        if (hrConfig.getExtraHoursMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)extraHours), this.hrConfigService.getValidatedExtraHoursTemplate(hrConfig));
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void refuse(ExtraHours extraHours) throws AxelorException {
        extraHours.setStatusSelect(ExtraHoursRepository.STATUS_REFUSED);
        extraHours.setRefusedBy(AuthUtils.getUser());
        extraHours.setRefusalDate(this.appBaseService.getTodayDate(extraHours.getCompany()));
        this.extraHoursRepo.save((Model)((Object)extraHours));
    }

    @Override
    public Message sendRefusalEmail(ExtraHours extraHours) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException {
        HRConfig hrConfig = this.hrConfigService.getHRConfig(extraHours.getCompany());
        if (hrConfig.getExtraHoursMailNotification().booleanValue()) {
            return this.templateMessageService.generateAndSendMessage((Model)((Object)extraHours), this.hrConfigService.getRefusedExtraHoursTemplate(hrConfig));
        }
        return null;
    }

    @Override
    public void compute(ExtraHours extraHours) {
        BigDecimal totalQty = BigDecimal.ZERO;
        List<ExtraHoursLine> extraHoursLines = extraHours.getExtraHoursLineList();
        for (ExtraHoursLine extraHoursLine : extraHoursLines) {
            totalQty = totalQty.add(extraHoursLine.getQty());
        }
        extraHours.setTotalQty(totalQty);
    }
}

