/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.leave;

import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveReason;
import com.axelor.apps.hr.db.LeaveRequest;
import com.axelor.apps.message.db.Message;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.mail.MessagingException;

public interface LeaveService {
    public BigDecimal computeDuration(LeaveRequest var1) throws AxelorException;

    public BigDecimal computeDuration(LeaveRequest var1, LocalDate var2, LocalDate var3) throws AxelorException;

    public BigDecimal computeDuration(LeaveRequest var1, LocalDateTime var2, LocalDateTime var3, int var4, int var5) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void manageSentLeaves(LeaveRequest var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void manageValidateLeaves(LeaveRequest var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void manageRefuseLeaves(LeaveRequest var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void manageCancelLeaves(LeaveRequest var1) throws AxelorException;

    public double computeStartDateWithSelect(LocalDate var1, int var2, WeeklyPlanning var3);

    public double computeEndDateWithSelect(LocalDate var1, int var2, WeeklyPlanning var3);

    @Transactional(rollbackOn={Exception.class})
    public LeaveRequest createEvents(LeaveRequest var1) throws AxelorException;

    public BigDecimal computeLeaveDaysByLeaveRequest(LocalDate var1, LocalDate var2, LeaveRequest var3, Employee var4) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void cancel(LeaveRequest var1) throws AxelorException;

    public Message sendCancellationEmail(LeaveRequest var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public void confirm(LeaveRequest var1) throws AxelorException;

    public Message sendConfirmationEmail(LeaveRequest var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public void validate(LeaveRequest var1) throws AxelorException;

    public Message sendValidationEmail(LeaveRequest var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    @Transactional(rollbackOn={Exception.class})
    public void refuse(LeaveRequest var1) throws AxelorException;

    public Message sendRefusalEmail(LeaveRequest var1) throws AxelorException, ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException;

    public boolean willHaveEnoughDays(LeaveRequest var1);

    @Transactional
    public LeaveLine createLeaveReasonToJustify(Employee var1, LeaveReason var2) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public LeaveLine addLeaveReasonOrCreateIt(Employee var1, LeaveReason var2) throws AxelorException;

    public boolean isLeaveDay(User var1, LocalDate var2);

    public List<LeaveRequest> getLeaves(User var1, LocalDate var2);
}

