/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.leave.management;

import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.LeaveLine;
import com.axelor.apps.hr.db.LeaveManagement;
import com.axelor.auth.db.User;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;

public class LeaveManagementService {
    @Inject
    protected AppBaseService appBaseService;

    public LeaveLine computeQuantityAvailable(LeaveLine leaveLine) {
        List<LeaveManagement> leaveManagementList = leaveLine.getLeaveManagementList();
        leaveLine.setTotalQuantity(BigDecimal.ZERO);
        if (leaveManagementList != null && !leaveManagementList.isEmpty()) {
            for (LeaveManagement leaveManagement : leaveManagementList) {
                leaveLine.setTotalQuantity(leaveLine.getTotalQuantity().add(leaveManagement.getValue()));
            }
            leaveLine.setQuantity(leaveLine.getTotalQuantity().subtract(leaveLine.getDaysValidated()));
        }
        return leaveLine;
    }

    @Transactional
    public LeaveManagement createLeaveManagement(LeaveLine leaveLine, User user, String comments, LocalDate date, LocalDate fromDate, LocalDate toDate, BigDecimal value) {
        LeaveManagement leaveManagement = new LeaveManagement();
        leaveManagement.setLeaveLine(leaveLine);
        leaveManagement.setUser(user);
        leaveManagement.setComments(comments);
        if (date == null) {
            leaveManagement.setDate(this.appBaseService.getTodayDate(user.getActiveCompany()));
        } else {
            leaveManagement.setDate(date);
        }
        leaveManagement.setFromDate(fromDate);
        leaveManagement.setToDate(toDate);
        leaveManagement.setValue(value.setScale(4, RoundingMode.HALF_EVEN));
        return leaveManagement;
    }

    @Transactional
    public void reset(LeaveLine leaveLine, User user, String comments, LocalDate date, LocalDate fromDate, LocalDate toDate) {
        LeaveManagement leaveManagement = this.createLeaveManagement(leaveLine, user, comments, date, fromDate, toDate, leaveLine.getQuantity().negate());
        leaveLine.addLeaveManagementListItem(leaveManagement);
        leaveLine.setQuantity(BigDecimal.ZERO);
        leaveLine.setTotalQuantity(BigDecimal.ZERO);
    }
}

