/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.hr.service.project;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.service.project.ProjectPlanningTimeService;
import com.axelor.apps.hr.service.publicHoliday.PublicHolidayHrService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectPlanningTime;
import com.axelor.apps.project.db.repo.ProjectPlanningTimeRepository;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPlanningTimeServiceImpl
implements ProjectPlanningTimeService {
    protected static final Logger LOG = LoggerFactory.getLogger(ProjectPlanningTimeService.class);
    protected ProjectPlanningTimeRepository planningTimeRepo;
    protected ProjectRepository projectRepo;
    protected TeamTaskRepository teamTaskRepo;
    protected WeeklyPlanningService weeklyPlanningService;
    protected PublicHolidayHrService holidayService;
    protected ProductRepository productRepo;
    protected UserRepository userRepo;

    @Inject
    public ProjectPlanningTimeServiceImpl(ProjectPlanningTimeRepository planningTimeRepo, ProjectRepository projectRepo, TeamTaskRepository teamTaskRepo, WeeklyPlanningService weeklyPlanningService, PublicHolidayHrService holidayService, ProductRepository productRepo, UserRepository userRepo) {
        this.planningTimeRepo = planningTimeRepo;
        this.projectRepo = projectRepo;
        this.teamTaskRepo = teamTaskRepo;
        this.weeklyPlanningService = weeklyPlanningService;
        this.holidayService = holidayService;
        this.productRepo = productRepo;
        this.userRepo = userRepo;
    }

    @Override
    public BigDecimal getTaskPlannedHrs(TeamTask task) {
        List plannings;
        BigDecimal totalPlanned = BigDecimal.ZERO;
        if (task != null && (plannings = this.planningTimeRepo.all().filter("self.task = ?1", new Object[]{task}).fetch()) != null) {
            totalPlanned = plannings.stream().map(ProjectPlanningTime::getPlannedHours).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return totalPlanned;
    }

    @Override
    public BigDecimal getProjectPlannedHrs(Project project) {
        List plannings;
        BigDecimal totalPlanned = BigDecimal.ZERO;
        if (project != null && (plannings = this.planningTimeRepo.all().filter("self.project = ?1 OR (self.project.parentProject = ?1 AND self.project.parentProject.isShowPhasesElements = ?2)", new Object[]{project, true}).fetch()) != null) {
            totalPlanned = plannings.stream().map(ProjectPlanningTime::getPlannedHours).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return totalPlanned;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void addMultipleProjectPlanningTime(Map<String, Object> datas) throws AxelorException {
        User user;
        if (datas.get("project") == null || datas.get("user") == null || datas.get("fromDate") == null || datas.get("toDate") == null) {
            return;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        LocalDateTime fromDate = LocalDateTime.parse(datas.get("fromDate").toString(), formatter);
        LocalDateTime toDate = LocalDateTime.parse(datas.get("toDate").toString(), formatter);
        TeamTask teamTask = null;
        Map objMap = (Map)datas.get("project");
        Project project = (Project)((Object)this.projectRepo.find(Long.parseLong(objMap.get("id").toString())));
        Integer timePercent = 0;
        if (datas.get("timepercent") != null) {
            timePercent = Integer.parseInt(datas.get("timepercent").toString());
        }
        if ((user = (User)((Object)this.userRepo.find(Long.parseLong((objMap = (Map)datas.get("user")).get("id").toString())))).getEmployee() == null) {
            return;
        }
        if (datas.get("task") != null) {
            objMap = (Map)datas.get("task");
            teamTask = (TeamTask)((Object)this.teamTaskRepo.find(Long.valueOf(objMap.get("id").toString())));
        }
        Product activity = null;
        if (datas.get("product") != null) {
            objMap = (Map)datas.get("product");
            activity = (Product)((Object)this.productRepo.find(Long.valueOf(objMap.get("id").toString())));
        }
        Employee employee = user.getEmployee();
        BigDecimal dailyWorkHrs = employee.getDailyWorkHours();
        while (fromDate.isBefore(toDate)) {
            LocalDate date = fromDate.toLocalDate();
            LOG.debug("Create Planning for the date: {}", (Object)date);
            double dayHrs = 0.0;
            if (employee.getWeeklyPlanning() != null) {
                dayHrs = this.weeklyPlanningService.getWorkingDayValueInDays(employee.getWeeklyPlanning(), date);
            }
            if (dayHrs > 0.0 && !this.holidayService.checkPublicHolidayDay(date, employee)) {
                ProjectPlanningTime planningTime = new ProjectPlanningTime();
                planningTime.setTask(teamTask);
                planningTime.setProduct(activity);
                planningTime.setTimepercent(timePercent);
                planningTime.setUser(user);
                planningTime.setDate(date);
                planningTime.setProject(project);
                planningTime.setIsIncludeInTurnoverForecast((Boolean)datas.get("isIncludeInTurnoverForecast"));
                BigDecimal totalHours = BigDecimal.ZERO;
                if (timePercent > 0) {
                    totalHours = dailyWorkHrs.multiply(new BigDecimal(timePercent)).divide(new BigDecimal(100));
                }
                planningTime.setPlannedHours(totalHours);
                this.planningTimeRepo.save((Model)((Object)planningTime));
            }
            fromDate = fromDate.plusDays(1L);
        }
    }

    @Override
    @Transactional
    public void removeProjectPlanningLines(List<Map<String, Object>> projectPlanningLines) {
        for (Map<String, Object> line : projectPlanningLines) {
            ProjectPlanningTime projectPlanningTime = (ProjectPlanningTime)((Object)this.planningTimeRepo.find(Long.parseLong(line.get("id").toString())));
            this.planningTimeRepo.remove((Model)((Object)projectPlanningTime));
        }
    }
}

